<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AdminController extends Controller
{
    public function login()
    {
        return view('index');
    }

    public function authenticate(Request $request)
    {
        
        $credentials = $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);
        
        if (Auth::attempt($credentials)) {
        
            $user = Auth::user();
            $request->session()->regenerate();
            $user->updated_at = now();
            $user->save();
            // return back()->with(['message' => 'Login Success.']);
            return redirect()->route('admin.dashboard');
            
        }
        else
        {
            return back()->with(['error' => 'Invalid email or password.']);
        }

    }

    public function logout(Request $request)
    {
        Auth::logout();
        
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        
        return redirect()->route('login');
    }

    public function dashboard()
    {
        return view('admin.dashboard.index');
    }
}
