<!DOCTYPE html>
<html lang="en">
    <head>
        <title>ReSEC Lab | Login</title>
        <meta charset="utf-8" />
        <meta name="description" content="" />
        <meta name="keywords" content="" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <meta property="og:locale" content="en_US" />
        <meta property="og:type" content="article" />
        <meta property="og:title" content="" />
        <meta property="og:url" content="#" />
        <meta property="og:site_name" content="ReSEC Lab" />
        <link rel="canonical" href="#" />
        <link rel="shortcut icon" href="<?php echo e(asset('assets/media/logos/favicon.ico')); ?>" />
        
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
        
        <link href="<?php echo e(asset('assets/plugins/global/plugins.bundle.css')); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset('assets/css/style.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    </head>
    <!--end::Head-->
    <!--begin::Body-->
    <body id="kt_body" class="bg-body">
        <!--begin::Main-->
        <!--begin::Root-->
        <div class="d-flex flex-column flex-root">
            <!--begin::Authentication - Sign-in -->
            <div class="d-flex flex-column flex-lg-row flex-column-fluid">
                <!--begin::Aside-->
                <div class="d-flex flex-column flex-lg-row-auto w-xl-800px positon-xl-relative" style="background-image: url(<?php echo e(asset('assets/media/login/login-aside.jpg')); ?>);background-repeat: no-repeat;background-size: cover;background-position: center">
                    <!--begin::Wrapper-->
                    <div class="d-flex flex-column position-xl-fixed top-0 bottom-0 w-xl-600px scroll-y">
                        <!--begin::Content-->
                        <div class="d-flex flex-row-fluid flex-column text-center p-10 pt-lg-20"></div>
                        <!--end::Content-->
                    </div>
                    <!--end::Wrapper-->
                </div>
                <!--end::Aside-->
                <!--begin::Body-->
                <div class="d-flex flex-column flex-lg-row-fluid py-10">
                    <!--begin::Content-->
                    <div class="d-flex flex-center flex-column flex-column-fluid">
                        <!--begin::Wrapper-->
                        <div class="w-lg-500px p-10 p-lg-15 mx-auto">
                            <!--begin::Form-->
                            <form class="form w-100" novalidate="novalidate" id="kt_sign_in_form" action="/authenticate" method="POST">
                                <?php echo csrf_field(); ?>
                                <!--begin::Heading-->
                                <div class="text-center mb-10">
                                    <a href="#" class="py-9 mb-5">
                                        <img alt="Logo" src="<?php echo e(asset('assets/media/logos/logo.png')); ?>" class="h-150px" />
                                    </a>
                                    <h1 class="text-dark mb-3 mt-5">Sign In to ReSEC Lab</h1>
                                </div>
                                <!--begin::Heading-->
                                <!--begin::Input group-->
                                <?php if(session()->has('message')): ?>   
                                    <div class="alert alert-success">
                                        <?php echo e(session()->get('message')); ?> 
                                    </div>
                                <?php elseif(session()->has('error')): ?>
                                    <div class="alert alert-danger">
                                        <?php echo e(session()->get('error')); ?> 
                                    </div>
                                <?php endif; ?>
                                <div class="fv-row mb-10">
                                    <!--begin::Label-->
                                    <label class="form-label fs-6 fw-bolder text-dark">Email</label>
                                    <!--end::Label-->
                                    <!--begin::Input-->
                                    <input class="form-control form-control-lg form-control-solid" type="text" name="email" autocomplete="off" />
                                    <!--end::Input-->
                                </div>
                                <!--end::Input group-->
                                <!--begin::Input group-->
                                <div class="fv-row mb-10">
                                    <!--begin::Wrapper-->
                                    <div class="d-flex flex-stack mb-2">
                                        <!--begin::Label-->
                                        <label class="form-label fw-bolder text-dark fs-6 mb-0">Password</label>
                                        <!--end::Label-->
                                    </div>
                                    <!--end::Wrapper-->
                                    <!--begin::Input-->
                                    <input class="form-control form-control-lg form-control-solid" type="password" name="password" autocomplete="off" />
                                    <!--end::Input-->
                                </div>
                                <!--end::Input group-->
                                <!--begin::Actions-->
                                <div class="text-center">
                                    <!--begin::Submit button-->
                                    <button type="submit" class="btn btn-lg btn-primary w-100 mb-5">Login</button>
                                    <!--end::Submit button-->              
                                </div>
                                <!--end::Actions-->
                            </form>
                            <!--end::Form-->
                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Content-->
                    <!--begin::Footer-->
                    <!--end::Footer-->
                </div>
                <!--end::Body-->
            </div>
            <!--end::Authentication - Sign-in-->
        </div>
        <!--end::Root-->
        <!--end::Main-->
        <!--begin::Javascript-->
       
        <!--begin::Global Javascript Bundle(used by all pages)-->
        <script src="<?php echo e(asset('assets/plugins/global/plugins.bundle.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/scripts.bundle.js')); ?>"></script>
        <!--end::Global Javascript Bundle-->
        <!--begin::Page Custom Javascript(used by this page)-->
        <script src="<?php echo e(asset('assets/js/custom/authentication/sign-in/general.js')); ?>"></script>
        <!--end::Page Custom Javascript-->
        <!--end::Javascript-->
    </body>
    <!--end::Body-->
</html><?php /**PATH /home/gologonowapp/public_html/reseclab/resources/views/login.blade.php ENDPATH**/ ?>