<?php

use App\Http\Controllers\AdminController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/', function () {
    return view('index');
});

Route::get('/login', [AdminController::class, 'login'])->name('login');
Route::post('/authenticate', [AdminController::class, 'authenticate']);
Route::post('/logout', [AdminController::class, 'logout'])->name('logout');

Route::prefix('admin')->name('admin.')->group(function () {
    
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
    Route::post('/lakedata', [AdminController::class, 'lakedata'])->name('lakedata');
    
    Route::get('/upload', [AdminController::class, 'upload'])->name('upload');
    Route::post('/store', [AdminController::class, 'store'])->name('store');

});