<!DOCTYPE html>
<html>
    <head>
        <title>Northwest Territories</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
        <link rel="stylesheet" href="https://openlayers.org/en/v6.6.1/css/ol.css" type="text/css">
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
        <script src="https://openlayers.org/en/v6.6.1/build/ol.js"></script>
    </head>
    <style>
        html,
        body {
          height: 100%;
          margin: 0;
          padding: 0;
        }
        #container {
          height: 100%;
          display: flex;
        }
        #sidebar {
          flex-basis: 15rem;
          flex-grow: 1;
          padding: 1rem;
          max-width: 30rem;
          height: 100%;
          box-sizing: border-box;
          overflow: auto;
        }
        #map {
          flex-basis: 0;
          flex-grow: 4;
          width: 100%;
        height: 100%;
        }
        .lakeImg {
          height: 55% !important;
          width: auto !important;
          background-repeat: no-repeat !important;
          background-size: contain !important;
          background-position: center !important;
          margin-top: 10px !important;
        }
        label {
          margin-top: 10px;
        }
        .form-select {
          margin-top: 5px;
        }
        .displayNone, .displayNoneModis
        {
          display: none !important;
        }
        .displayBlock, .displayBlockModis
        {
          display: block !important;
        }
        p.error_msg {
            text-align: center;
            margin:  auto;
            margin-top: 16px;
            font-size: 18px;
            font-weight: 400;
            color: red;
        }
    </style>
    <body>
        <div id="container">
            <div id="map" class="map"></div>
            <div id="sidebar">
                <p id="lakeName">Select Lake from Map</p>
                <label class="displayNone">Product</label>
                <select class="form-select product_cls displayNone" aria-label="Default select example">
                    <option value="surface_temperature">Surface Temperature (Landsat-derived)</option>
                    <option value="ice_temperature">Surface Temperature (MODIS)</option>
                </select>
                <label class="displayNone">Year</label>
                <select class="form-select year_cls displayNone" aria-label="Default select example">
                      <option value="2025">2025</option>
                      <option value="2024">2024</option>
                      <option value="2023">2023</option>
                      <option value="2022">2022</option>
                      <option value="2021">2021</option>
                      <option value="2020">2020</option>
                      <option value="2019">2019</option>
                      <option value="2018">2018</option>
                      <option value="2017">2017</option>
                      <option value="2016">2016</option>
                      <option value="2015">2015</option>
                      <option value="2014">2014</option>
                      <option value="2013">2013</option>
                      <option value="2012">2012</option>
                      <option value="2011">2011</option>
                      <option value="2010">2010</option>
                      <option value="2009">2009</option>
                      <option value="2008">2008</option>
                      <option value="2007">2007</option>
                      <option value="2006">2006</option>
                      <option value="2005">2005</option>
                      <option value="2004">2004</option>
                      <option value="2003">2003</option>
                      <option value="2002">2002</option>
                      <option value="2001">2001</option>
                      <option value="2000">2000</option>
                      <option value="1999">1999</option>
                      <option value="1998">1998</option>
                      <option value="1997">1997</option>
                      <option value="1996">1996</option>
                      <option value="1995">1995</option>
                      <option value="1994">1994</option>
                      <option value="1993">1993</option>
                      <option value="1992">1992</option>
                      <option value="1991">1991</option>
                      <option value="1990">1990</option>
                      <option value="1989">1989</option>
                      <option value="1988">1988</option>
                      <option value="1987">1987</option>
                      <option value="1986">1986</option>
                      <option value="1985">1985</option>
                      <option value="1984">1984</option>
                </select>
                <label class="displayNone">Month</label>
                <select class="form-select month_cls displayNone" aria-label="Default select example">
                    <option value="01">January</option>
                    <option value="02">February</option>
                    <option value="03">March</option>
                    <option value="04">April</option>
                    <option value="05">May</option>
                    <option value="06">June</option>
                    <option value="07">July</option>
                    <option value="08">August</option>
                    <option value="09">September</option>
                    <option value="10">October</option>
                    <option value="11">November</option>
                    <option value="12">December</option>
                </select>
                <label class="displayNoneModis">Day</label>
                <select class="form-select day_cls displayNoneModis" aria-label="Default select example">
                    <option value="">Select day</option>
                    <option value="01">01</option>
                    <option value="02">02</option>
                    <option value="03">03</option>
                    <option value="04">04</option>
                    <option value="05">05</option>
                    <option value="06">06</option>
                    <option value="07">07</option>
                    <option value="08">08</option>
                    <option value="09">09</option>
                    <option value="10">10</option>
                    <option value="11">11</option>
                    <option value="12">12</option>
                    <option value="13">13</option>
                    <option value="14">14</option>
                    <option value="15">15</option>
                    <option value="16">16</option>
                    <option value="17">17</option>
                    <option value="18">18</option>
                    <option value="19">19</option>
                    <option value="20">20</option>
                    <option value="21">21</option>
                    <option value="22">22</option>
                    <option value="23">23</option>
                    <option value="24">24</option>
                    <option value="25">25</option>
                    <option value="26">26</option>
                    <option value="27">27</option>
                    <option value="28">28</option>
                    <option value="29">29</option>
                    <option value="30">30</option>
                    <option value="31">31</option>
                    
                </select>
                <p class="error_msg displayNone">Lake data not found.</p>
                <div class="lakeImg displayNone"></div>
            </div>
        </div>
        <script>
            
            // var coord1 = ol.proj.fromLonLat([-115.6972, 63.4215]);
            // var coord2 = ol.proj.fromLonLat([-110.6972, 65.4215]);
            var map = new ol.Map({
                target: 'map',
                layers: [
                    new ol.layer.Tile({
                        source: new ol.source.OSM()
                    }),
                    new ol.layer.Vector({
                        source: new ol.source.Vector({
                        url: '/assets/northwestterritories.kml',
                        format: new ol.format.KML()
                        })
                    })
                ],
                view: new ol.View({
                    center: ol.proj.fromLonLat([-110.6972, 63.4215]),
                    zoom: 6,
                    minZoom: 3
                }),
                controls: ol.control.defaults({
                    zoom: true,
                    attribution: false
                })
            });
            
            // Add a click event listener to the KML layer
            map.on('click', function(evt) {
                var feature = map.forEachFeatureAtPixel(evt.pixel, function(feature) {
                return feature;
            });
    
                if (feature) {
                    
                    console.log(feature.getProperties().Lake_name);
                    
                    const sidebar = document.getElementById("lakeName");
                    sidebar.innerHTML = "Lake name: "+feature.getProperties().Lake_name;
                    
                    $('select.form-select').removeClass('displayNone');
                    $('select.form-select').addClass('displayBlock');
                    
                    $('div.lakeImg').removeClass('displayNone');
                    $('div.lakeImg').addClass('displayBlock');
                    
                    $('label').removeClass('displayNone');
                    $('label').addClass('displayBlock');
                    
                    localStorage.setItem("lakeName", feature.getProperties().Lake_name);
                    localStorage.setItem("product", $('.product_cls').val());
                    localStorage.setItem("year", $('.year_cls').val());
                    localStorage.setItem("month", $('.month_cls').val());
                    localStorage.setItem("day", $('.day_cls').val());
                    
                    var lakeName = localStorage.getItem("lakeName");
                    var product = localStorage.getItem("product");
                    var year = localStorage.getItem("year");
                    var month = localStorage.getItem("month");
                    var day = localStorage.getItem("day");
                    
                    if(day == "")
                    {
                        $('div.lakeImg').css('background-image', "url('"+product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+".png')");
                        $.ajax({
                          url: product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+".png",
                          success: function() {
                            $('.error_msg').removeClass('displayBlock');
                            $('.error_msg').addClass('displayNone');
                          },
                          error: function() {
                            $('.error_msg').removeClass('displayNone');
                            $('.error_msg').addClass('displayBlock');
                          }
                        });    
                    }
                    else
                    {
                        $('div.lakeImg').css('background-image', "url('"+product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+"_"+day+".png')");
                        $.ajax({
                          url: product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+"_"+day+".png",
                          success: function() {
                            $('.error_msg').removeClass('displayBlock');
                            $('.error_msg').addClass('displayNone');
                          },
                          error: function() {
                            $('.error_msg').removeClass('displayNone');
                            $('.error_msg').addClass('displayBlock');
                          }
                        });
                    }
                    
                    // if(product == 'ice_temperature')
                    // {
                    //     $('.day_cls').removeClass('displayNoneModis');
                    //     $('.day_cls').addClass('displayBlockModis');
                    // }
                    // else
                    // {
                    //     $('.day_cls').addClass('displayNoneModis');
                    //     $('.day_cls').removeClass('displayBlock');
                    //     $('.day_cls').removeClass('displayBlockModis');
                    // }
                    
                }
            });
          
          $('.product_cls').on('change', function() {
            
            if($(this).val() == 'surface_temperature')
            {
                var layer = map.getLayers().getArray()[1];
                layer.setSource(new ol.source.Vector({
                    url: '/assets/northwestterritories.kml',
                    format: new ol.format.KML()
                }));
            }
            
            else if($(this).val() == 'ice_temperature')
            {
                var layer = map.getLayers().getArray()[1];
                layer.setSource(new ol.source.Vector({
                    url: '/assets/northwestterritories_modis.kml',
                    format: new ol.format.KML()
                }));
            }
            
            localStorage.setItem("product", $('.product_cls').val());
            localStorage.setItem("year", $('.year_cls').val());
            localStorage.setItem("month", $('.month_cls').val());
            localStorage.setItem("day", $('.day_cls').val());
            
            var lakeName = localStorage.getItem("lakeName");
            var product = localStorage.getItem("product");
            var year = localStorage.getItem("year");
            var month = localStorage.getItem("month");
            var day = localStorage.getItem("day");
              
            if(day == "")
            {
                $('div.lakeImg').css('background-image', "url('"+product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+".png')");
                $.ajax({
                  url: product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+".png",
                  success: function() {
                    $('.error_msg').removeClass('displayBlock');
                    $('.error_msg').addClass('displayNone');
                  },
                  error: function() {
                    $('.error_msg').removeClass('displayNone');
                    $('.error_msg').addClass('displayBlock');
                  }
                });    
            }
            else
            {
                $('div.lakeImg').css('background-image', "url('"+product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+"_"+day+".png')");
                $.ajax({
                  url: product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+"_"+day+".png",
                  success: function() {
                    $('.error_msg').removeClass('displayBlock');
                    $('.error_msg').addClass('displayNone');
                  },
                  error: function() {
                    $('.error_msg').removeClass('displayNone');
                    $('.error_msg').addClass('displayBlock');
                  }
                });
            }
            
            // if(product == 'ice_temperature')
            // {
            //     $('.day_cls').removeClass('displayNoneModis');
            //     $('.day_cls').addClass('displayBlockModis');
            // }
            // else
            // {
            //     $('.day_cls').addClass('displayNoneModis');
            //     $('.day_cls').removeClass('displayBlock');
            //     $('.day_cls').removeClass('displayBlockModis');
            // }
          });
          
          $('.year_cls').on('change', function() {
    
            localStorage.setItem("product", $('.product_cls').val());
            localStorage.setItem("year", $('.year_cls').val());
            localStorage.setItem("month", $('.month_cls').val());
            localStorage.setItem("day", $('.day_cls').val());
            
            var lakeName = localStorage.getItem("lakeName");
            var product = localStorage.getItem("product");
            var year = localStorage.getItem("year");
            var month = localStorage.getItem("month");
            var day = localStorage.getItem("day");
            
            if(day == "")
            {
                $('div.lakeImg').css('background-image', "url('"+product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+".png')");
                $.ajax({
                  url: product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+".png",
                  success: function() {
                    $('.error_msg').removeClass('displayBlock');
                    $('.error_msg').addClass('displayNone');
                  },
                  error: function() {
                    $('.error_msg').removeClass('displayNone');
                    $('.error_msg').addClass('displayBlock');
                  }
                });    
            }
            else
            {
                $('div.lakeImg').css('background-image', "url('"+product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+"_"+day+".png')");
                $.ajax({
                  url: product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+"_"+day+".png",
                  success: function() {
                    $('.error_msg').removeClass('displayBlock');
                    $('.error_msg').addClass('displayNone');
                  },
                  error: function() {
                    $('.error_msg').removeClass('displayNone');
                    $('.error_msg').addClass('displayBlock');
                  }
                });
            }
            
            // if(product == 'ice_temperature')
            // {
            //     $('.day_cls').removeClass('displayNoneModis');
            //     $('.day_cls').addClass('displayBlockModis');
            // }
            // else
            // {
            //     $('.day_cls').addClass('displayNoneModis');
            //     $('.day_cls').removeClass('displayBlock');
            //     $('.day_cls').removeClass('displayBlockModis');
            // }
          });
          
          $('.month_cls').on('change', function() {
    
            localStorage.setItem("product", $('.product_cls').val());
            localStorage.setItem("year", $('.year_cls').val());
            localStorage.setItem("month", $('.month_cls').val());
            localStorage.setItem("day", $('.day_cls').val());
            
            var lakeName = localStorage.getItem("lakeName");
            var product = localStorage.getItem("product");
            var year = localStorage.getItem("year");
            var month = localStorage.getItem("month");
            var day = localStorage.getItem("day");
            
            if(day == "")
            {
                $('div.lakeImg').css('background-image', "url('"+product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+".png')");
                $.ajax({
                  url: product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+".png",
                  success: function() {
                    $('.error_msg').removeClass('displayBlock');
                    $('.error_msg').addClass('displayNone');
                  },
                  error: function() {
                    $('.error_msg').removeClass('displayNone');
                    $('.error_msg').addClass('displayBlock');
                  }
                });    
            }
            else
            {
                $('div.lakeImg').css('background-image', "url('"+product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+"_"+day+".png')");
                $.ajax({
                  url: product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+"_"+day+".png",
                  success: function() {
                    $('.error_msg').removeClass('displayBlock');
                    $('.error_msg').addClass('displayNone');
                  },
                  error: function() {
                    $('.error_msg').removeClass('displayNone');
                    $('.error_msg').addClass('displayBlock');
                  }
                });
            }
            
            
            // if(product == 'ice_temperature')
            // {
            //     $('.day_cls').removeClass('displayNoneModis');
            //     $('.day_cls').addClass('displayBlockModis');
            // }
            // else
            // {
            //     $('.day_cls').addClass('displayNoneModis');
            //     $('.day_cls').removeClass('displayBlock');
            //     $('.day_cls').removeClass('displayBlockModis');
            // }
          });
          
          $('.day_cls').on('change', function() {
    
            localStorage.setItem("product", $('.product_cls').val());
            localStorage.setItem("year", $('.year_cls').val());
            localStorage.setItem("month", $('.month_cls').val());
            localStorage.setItem("day", $('.day_cls').val());
            
            var lakeName = localStorage.getItem("lakeName");
            var product = localStorage.getItem("product");
            var year = localStorage.getItem("year");
            var month = localStorage.getItem("month");
            var day = localStorage.getItem("day");
            
            if(day == "")
            {
                $('div.lakeImg').css('background-image', "url('"+product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+".png')");
                $.ajax({
                  url: product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+".png",
                  success: function() {
                    $('.error_msg').removeClass('displayBlock');
                    $('.error_msg').addClass('displayNone');
                  },
                  error: function() {
                    $('.error_msg').removeClass('displayNone');
                    $('.error_msg').addClass('displayBlock');
                  }
                });    
            }
            else
            {
                $('div.lakeImg').css('background-image', "url('"+product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+"_"+day+".png')");
                $.ajax({
                  url: product+"/"+year+"/"+month+"/"+lakeName.replace(/ /g,"_")+"_"+year+"_"+month+"_"+day+".png",
                  success: function() {
                    $('.error_msg').removeClass('displayBlock');
                    $('.error_msg').addClass('displayNone');
                  },
                  error: function() {
                    $('.error_msg').removeClass('displayNone');
                    $('.error_msg').addClass('displayBlock');
                  }
                });
            }
            
            
            // if(product == 'ice_temperature')
            // {
            //     $('.day_cls').removeClass('displayNoneModis');
            //     $('.day_cls').addClass('displayBlockModis');
            // }
            // else
            // {
            //     $('.day_cls').addClass('displayNoneModis');
            //     $('.day_cls').removeClass('displayBlock');
            //     $('.day_cls').removeClass('displayBlockModis');
            // }
          });
          
        </script>
    </body>
</html>