<!DOCTYPE html>
<html lang="en">
	<!--begin::Head-->
	<head>
		<title>ReSEC Lab | Upload</title>
		@include('global.header-links')
		<!--end::Global Stylesheets Bundle-->
	</head>
	<!--end::Head-->
	<!--begin::Body-->
	<body id="kt_body" class="header-fixed header-tablet-and-mobile-fixed toolbar-enabled toolbar-fixed aside-enabled aside-fixed" style="--kt-toolbar-height:55px;--kt-toolbar-height-tablet-and-mobile:55px">
		<!--begin::Main-->
		<!--begin::Root-->
		<div class="d-flex flex-column flex-root">
			<!--begin::Page-->
			<div class="page d-flex flex-row flex-column-fluid">
				<!--begin::Aside-->
				@include('partials.sidebar')
				<!--end::Aside-->
				<!--begin::Wrapper-->
				<div class="wrapper d-flex flex-column flex-row-fluid" id="kt_wrapper">
					<!--begin::Header-->
					@include('partials.header')
					<!--end::Header-->
					<!--begin::Content-->
					<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
						<!--begin::Toolbar-->
						<div class="toolbar" id="kt_toolbar">
							<!--begin::Container-->
							<div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
								<!--begin::Page title-->
								<div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
									<!--begin::Title-->
									<h1 class="d-flex text-dark fw-bolder fs-3 align-items-center my-1">Upload Lake Data</h1>
									<!--end::Title-->
								</div>
								<!--end::Page title-->
							</div>
							<!--end::Container-->
						</div>
						<!--end::Toolbar-->
						<!--begin::Post-->
						<div class="post d-flex flex-column-fluid" id="kt_post">
							<!--begin::Container-->
							<div id="kt_content_container" class="container-xxl">
								<!--begin::Products-->
								<div class="card mb-5 mb-xl-10">
									<!--begin::Card header-->
									<div class="card-header border-0 cursor-pointer" role="button" data-bs-toggle="collapse" data-bs-target="#kt_account_profile_details" aria-expanded="true" aria-controls="kt_account_profile_details">
										<!--begin::Card title-->
										<div class="card-title m-0">
											<h3 class="fw-bolder m-0">New Lake Data</h3>
										</div>
										<!--end::Card title-->
									</div>
									<!--begin::Card header-->
									<!--begin::Content-->
									<div id="kt_account_settings_profile_details" class="collapse show">
										<!--begin::Form-->
										<form id="kt_account_profile_details_form" class="form" action="{{route('admin.store')}}" method="POST" enctype="multipart/form-data">
										    @csrf
											<!--begin::Card body-->
											<div class="card-body border-top p-9">
											    @if(session()->has('message'))   
                                                    <div class="alert alert-success">
                                                        {{ session()->get('message') }} 
                                                    </div>
                                                @elseif(session()->has('error'))
                                                    <div class="alert alert-danger">
                                                        {{ session()->get('error') }} 
                                                    </div>
                                                @endif
											    <!--begin::Input group-->
												<div class="row mb-6">
													<!--begin::Label-->
													<label class="col-lg-4 col-form-label fw-bold fs-6">Lake Image</label>
													<!--end::Label-->
													<!--begin::Col-->
													<div class="col-lg-8">
														<!--begin::Image input-->
														<div class="image-input image-input-outline" data-kt-image-input="true" >
															<!--begin::Preview existing avatar-->
															<div class="image-input-wrapper w-125px h-125px" ></div>
															<!--end::Preview existing avatar-->
															<!--begin::Label-->
															<label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Change Lake Image">
																<i class="bi bi-pencil-fill fs-7"></i>
																<!--begin::Inputs-->
																<input type="file" name="lakeimage" accept=".png, .jpg, .jpeg" required />
																<input type="hidden" name="lakeimage_remove" />
																<!--end::Inputs-->
															</label>
															<!--end::Label-->
															<!--begin::Cancel-->
															<span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Cancel Lake Image">
																<i class="bi bi-x fs-2"></i>
															</span>
															<!--end::Cancel-->
															<!--begin::Remove-->
															<span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Remove Lake Image">
																<i class="bi bi-x fs-2"></i>
															</span>
															<!--end::Remove-->
														</div>
														<!--end::Image input-->
														<!--begin::Hint-->
														<div class="form-text">Allowed file types: png, jpg, jpeg.</div>
														<!--end::Hint-->
													</div>
													<!--end::Col-->
												</div>
												<!--end::Input group-->
												<!--begin::Input group-->
												<div class="row mb-6">
													<!--begin::Label-->
													<label class="col-lg-4 col-form-label required fw-bold fs-6">Lake</label>
													<!--end::Label-->
													<!--begin::Col-->
													<div class="col-lg-8 fv-row">
														<select id="lake_data" name="lakename" aria-label="Select Lake" data-control="select2" data-placeholder="Select lake..." class="form-select form-select-solid form-select-lg lakename" required>
															<option value="">Select lake...</option>
															
														</select>
													</div>
													<!--end::Col-->
												</div>
												<!--end::Input group-->
												<!--begin::Input group-->
												<div class="row mb-6">
													<!--begin::Label-->
													<label class="col-lg-4 col-form-label required fw-bold fs-6">Product</label>
													<!--end::Label-->
													<!--begin::Col-->
													<div class="col-lg-8 fv-row">
														<select id="product_data" name="product" aria-label="Select Product" data-control="select2" data-placeholder="Select product..." class="form-select form-select-solid form-select-lg product" required>
															<option value="">Select Product...</option>
															<option value="surface_temperature">Surface Temperature (Landsat-derived)</option>
															<option value="ice_temperature">Surface Temperature (MODIS)</option>
														</select>
													</div>
													<!--end::Col-->
												</div>
												<!--end::Input group-->
												<!--begin::Input group-->
												<div class="row mb-6">
													<!--begin::Label-->
													<label class="col-lg-4 col-form-label required fw-bold fs-6">Year</label>
													<!--end::Label-->
													<!--begin::Col-->
													<div class="col-lg-8 fv-row">
														<input type="text" name="year" class="form-control form-control-lg form-control-solid year" placeholder="2023" maxlength="4" minlength="4" required/>
													</div>
													<!--<div class="col-lg-8 fv-row">-->
													<!--	<select name="language" aria-label="Select Language" data-control="select2" data-placeholder="Select year..." class="form-select form-select-solid form-select-lg">-->
													<!--		<option value="">Select Year...</option>-->
													<!--		<option value="2021">2021</option>-->
													<!--		<option value="2020">2020</option>-->
													<!--		<option value="2019">2019</option>-->
													<!--		<option value="2018">2018</option>-->
													<!--		<option value="2017">2017</option>-->
													<!--		<option value="2016">2016</option>-->
													<!--		<option value="2015">2015</option>-->
													<!--		<option value="2014">2014</option>-->
													<!--		<option value="2013">2013</option>-->
													<!--		<option value="2012">2012</option>-->
													<!--		<option value="2011">2011</option>-->
													<!--		<option value="2010">2010</option>-->
													<!--		<option value="2009">2009</option>-->
													<!--		<option value="2008">2008</option>-->
													<!--		<option value="2007">2007</option>-->
													<!--		<option value="2006">2006</option>-->
													<!--		<option value="2005">2005</option>-->
													<!--		<option value="2004">2004</option>-->
													<!--		<option value="2003">2003</option>-->
													<!--		<option value="2002">2002</option>-->
													<!--		<option value="2001">2001</option>-->
													<!--		<option value="2000">2000</option>-->
													<!--		<option value="1999">1999</option>-->
													<!--		<option value="1998">1998</option>-->
													<!--		<option value="1997">1997</option>-->
													<!--		<option value="1996">1996</option>-->
													<!--		<option value="1995">1995</option>-->
													<!--		<option value="1994">1994</option>-->
													<!--		<option value="1993">1993</option>-->
													<!--		<option value="1992">1992</option>-->
													<!--		<option value="1991">1991</option>-->
													<!--		<option value="1990">1990</option>-->
													<!--		<option value="1989">1989</option>-->
													<!--		<option value="1988">1988</option>-->
													<!--		<option value="1987">1987</option>-->
													<!--		<option value="1986">1986</option>-->
													<!--		<option value="1985">1985</option>-->
													<!--		<option value="1984">1984</option>-->
													<!--	</select>-->
													<!--</div>-->
													<!--end::Col-->
												</div>
												<!--end::Input group-->
												<!--begin::Input group-->
												<div class="row mb-6">
													<!--begin::Label-->
													<label class="col-lg-4 col-form-label required fw-bold fs-6">Month</label>
													<!--end::Label-->
													<!--begin::Col-->
													<div class="col-lg-8 fv-row">
														<select name="month" aria-label="Select Month" data-control="select2" data-placeholder="Select month..." class="form-select form-select-solid form-select-lg month" required>
															<option value="">Select Month...</option>
															<option value="01">January</option>
															<option value="02">February</option>
															<option value="03">March</option>
															<option value="04">April</option>
															<option value="05">May</option>
															<option value="06">June</option>
															<option value="07">July</option>
															<option value="08">August</option>
															<option value="09">September</option>
															<option value="10">October</option>
															<option value="11">November</option>
															<option value="12">December</option>
														</select>
													</div>
													<!--end::Col-->
												</div>
												<!--end::Input group-->
												<!--begin::Input group-->
												<div class="row mb-6">
													<!--begin::Label-->
													<label class="col-lg-4 col-form-label fw-bold fs-6">Day</label>
													<!--end::Label-->
													<!--begin::Col-->
													<div class="col-lg-8 fv-row">
														<select name="day" aria-label="Select Day" data-control="select2" data-placeholder="Select day..." class="form-select form-select-solid form-select-lg day">
															<option value="">Select day...</option>
															<option value="01">01</option>
															<option value="02">02</option>
															<option value="03">03</option>
															<option value="04">04</option>
															<option value="05">05</option>
															<option value="06">06</option>
															<option value="07">07</option>
															<option value="08">08</option>
															<option value="09">09</option>
															<option value="10">10</option>
															<option value="11">11</option>
															<option value="12">12</option>
															<option value="13">13</option>
															<option value="14">14</option>
															<option value="15">15</option>
															<option value="16">16</option>
															<option value="17">17</option>
															<option value="18">18</option>
															<option value="19">19</option>
															<option value="20">20</option>
															<option value="21">21</option>
															<option value="22">22</option>
															<option value="23">23</option>
															<option value="24">24</option>
															<option value="25">25</option>
															<option value="26">26</option>
															<option value="27">27</option>
															<option value="28">28</option>
															<option value="29">29</option>
															<option value="30">30</option>
															<option value="31">31</option>
														</select>
													</div>
													<!--end::Col-->
												</div>
												<!--end::Input group-->
											</div>
											<!--end::Card body-->
											<!--begin::Actions-->
											<div class="card-footer d-flex justify-content-end py-6 px-9">
												<button type="submit" class="btn btn-primary btn_lakedata" id="kt_account_profile_details_submit">Save Lake Data</button>
											</div>
											<!--end::Actions-->
										</form>
										<!--end::Form-->
									</div>
									<!--end::Content-->
								</div>
								<!--end::Basic info-->
							</div>
							<!--end::Container-->
						</div>
						<!--end::Post-->
					</div>
					<!--end::Content-->
					<!--begin::Footer-->
					@include('partials.footer')
					<!--end::Footer-->
				</div>
				<!--end::Wrapper-->
			</div>
			<!--end::Page-->
		</div>
		<!--end::Root-->
		<!--begin::Javascript-->
		@include('global.footer-links')
		<div id="mapcontainer">
        	<div id="map" class="map"></div>
        </div>
		<!--end::Javascript-->
	</body>
	<!--end::Body-->
</html>

<script>

	var vectorLayer = new ol.layer.Vector({
		source: new ol.source.Vector({
			url: '/assets/territories_list.kml',
			format: new ol.format.KML()
		})
	});
	
	vectorLayer.getSource().on('addfeature', function(event) {
		var feature = event.feature;
		var name = feature.get('name');
		$('#lake_data').append(`<option value="${name}">${name}</option>`);
	});
	var map = new ol.Map({
		target: 'map',
		layers: [
		new ol.layer.Tile({
			source: new ol.source.OSM()
		}),
		vectorLayer
		],
		view: new ol.View({
		center: ol.proj.fromLonLat([-110.6972, 63.4215]),
		zoom: 6,
		minZoom: 3
		}),
		controls: ol.control.defaults({
		zoom: true,
		attribution: false
		})
	});
</script>