<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AdminController extends Controller
{
    public function login()
    {
        return view('login');
    }

    public function authenticate(Request $request)
    {
        
        $credentials = $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);
        
        if (Auth::attempt($credentials)) {
        
            $user = Auth::user();
            $request->session()->regenerate();
            $user->updated_at = now();
            $user->save();
            
            return redirect()->route('admin.dashboard');
            
        }
        else
        {
            return back()->with(['error' => 'Invalid email or password.']);
        }

    }

    public function logout(Request $request)
    {
        Auth::logout();
        
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        
        return redirect()->route('login');
    }

    public function dashboard()
    {
        return view('admin.dashboard.index');
    }
    
    public function lakedata(Request $request)
    {
        return $request->all();
    }
    
    public function upload()
    {
        return view('admin.dashboard.upload');
    }
    
    public function store(Request $request)
    {
        if ($request->hasFile('lakeimage'))
        {
            if($request->day != null)
            {
                $filename = str_replace(' ', '_', request()->lakename).'_'.request()->year.'_'.request()->month.'_'.request()->day.'.'.request()->lakeimage->getClientOriginalExtension();
                $request->lakeimage->move(public_path(request()->product.'/'.request()->year.'/'.request()->month.'/'.request()->day), $filename);
                $file = request()->product.'/'.request()->year.'/'.request()->month.'/'.request()->day.'/'.$filename;
            }
            else
            {
                $filename = str_replace(' ', '_', request()->lakename).'_'.request()->year.'_'.request()->month.'.'.request()->lakeimage->getClientOriginalExtension();
                $request->lakeimage->move(public_path(request()->product.'/'.request()->year.'/'.request()->month), $filename);
                $file = request()->product.'/'.request()->year.'/'.request()->month.'/'.$filename;
            }
            return back()->with(['message' => 'Lake Data added successfully.']);
        }
        else
        {
            return back()->with(['error' => 'Something went wrong.']);
        }
    }
}
