<?php $__env->startSection('title', 'Users'); ?>

<?php $__env->startSection('content'); ?>
    <!-- bootstrap datepicker -->
    <link rel="stylesheet" href="<?php echo asset('assets/vendor_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css'); ?>">

    <style>
        .form-horizontal {
            padding: 2em;
        }

    </style>

    <!-- Start Page content -->
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="box">

                    <div class="box-header with-border">
                        <h3><?php echo e($page); ?></h3>
                    </div>

                    <form method="post" class="form-horizontal" action="<?php echo e(url('reports/download')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="model" value="User">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status"><?php echo app('translator')->get('view_pages.select_status'); ?></label>
                                    <select name="status" id="status" class="form-control" required>
                                        <option value="" selected disabled><?php echo app('translator')->get('view_pages.select_status'); ?></option>
                                        <option value="1"><?php echo app('translator')->get('view_pages.active'); ?></option>
                                        <option value="0"><?php echo app('translator')->get('view_pages.inactive'); ?></option>
                                    </select>
                                    <span class="text-danger"><?php echo e($errors->first('status')); ?></span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="date_option"><?php echo app('translator')->get('view_pages.date_option'); ?></label>
                                    <select name="date_option" id="date_option" class="form-control">
                                        <option value="date"><?php echo app('translator')->get('view_pages.date'); ?></option>
                                        <option value="today"><?php echo app('translator')->get('view_pages.today'); ?></option>
                                        <option value="week"><?php echo app('translator')->get('view_pages.week'); ?></option>
                                        <option value="month"><?php echo app('translator')->get('view_pages.month'); ?></option>
                                        <option value="year"><?php echo app('translator')->get('view_pages.year'); ?></option>
                                    </select>
                                    <span class="text-danger"><?php echo e($errors->first('date_option')); ?></span>
                                </div>
                            </div>

                            <div class="col-md-6 dateDiv">
                                <div class="form-group">
                                    <label for="from"><?php echo app('translator')->get('view_pages.from'); ?> <span class="text-danger">*</span></label>
                                    <input class="form-control datepicker" type="text" id="from" name="from"
                                        value="<?php echo e(old('from')); ?>" required
                                        placeholder="<?php echo e(now()->startOfMonth()->format('Y-m-d')); ?>" autocomplete="off">
                                    <span class="text-danger"><?php echo e($errors->first('from')); ?></span>
                                </div>
                            </div>

                            <div class="col-md-6 dateDiv">
                                <div class="form-group">
                                    <label for="to"><?php echo app('translator')->get('view_pages.to'); ?> <span class="text-danger">*</span></label>
                                    <input class="form-control datepicker" type="text" id="to" name="to"
                                        value="<?php echo e(old('to')); ?>" required placeholder="<?php echo e(now()->format('Y-m-d')); ?>"
                                        autocomplete="off">
                                    <span class="text-danger"><?php echo e($errors->first('to')); ?></span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="format"><?php echo app('translator')->get('view_pages.select_format'); ?> <span
                                            class="text-danger">*</span></label>
                                    <select name="format" id="format" class="form-control" required>
                                        <option value="" selected disabled><?php echo app('translator')->get('view_pages.select_format'); ?></option>
                                        <?php $__currentLoopData = $formats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $format): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($format); ?>"><?php echo e($format); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <span class="text-danger"><?php echo e($errors->first('format')); ?></span>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-12">
                                <button class="btn btn-primary btn-sm pull-right submit" type="button">
                                    <?php echo app('translator')->get('view_pages.download'); ?>
                                </button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </section>

    <script src="<?php echo e(asset('assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js')); ?>">
    </script>

    <script>
        //Date picker
        $('.datepicker').datepicker({
            autoclose: true,
            format: 'yyyy-mm-dd',
            endDate: 'today'
        });

        $(document).on('change', '#date_option', function() {
            dateOption();
        });

        $(document).on('click', '.submit', function(e) {

            var validate = validateForm();

            if (validate) {
                let filterColumn = ['status', 'date_option'];
                let query = '?';

                var from = $('#from').val();
                var to = $('#to').val();

                $.each(filterColumn, function(index, value) {
                    var val = $('#' + value).val();

                    if (value == 'date_option') {
                        if (val == 'date') {
                            val = from + '<>' + to;
                        }
                    }

                    if (val != null && val != '') {
                        query += value + '=' + val + '&';
                    }
                });

                let url = '<?php echo e(url('reports/download')); ?>';
                let searchUrl = url + query;

                $.ajax({
                    url: searchUrl,
                    data: $('form').serialize(),
                    method: 'post',
                    success: function(res) {
                        $('form').trigger("reset");
                        dateOption();
                        window.location = res;
                    }
                });
            }
        });

        function validateForm() {
            let validateEle = ['date_option', 'format'];
            var returnVar = true;

            $.each(validateEle, function(i, ele) {
                if (ele == 'date_option') {
                    if ($('#' + ele).val() == 'date') {
                        if ($('#from').val() == '' || $('#from').val() == null) {
                            $('#from').next().text('The Field is required');
                            $('#to').next().text('The Field is required');
                            returnVar = false;
                        } else {
                            $('#from').next().text('');
                            $('#to').next().text('');
                        }
                    } else {
                        $('#from').next().text('');
                        $('#to').next().text('');
                    }
                } else {
                    ele = $('#' + ele);

                    if (ele.val() == '' || ele.val() == null) {
                        ele.next().text('The Field is required');
                        returnVar = false;
                    } else {
                        ele.next().text('');
                    }
                }
            });

            return returnVar;
        }

        function dateOption() {
            var option = $('#date_option').val();

            if (option == 'date') {
                $('.dateDiv').show();
                $('#from').attr('required', true);
                $('#to').attr('required', true);
            } else {
                $('.dateDiv').hide();
                $('#from').attr('required', false);
                $('#to').attr('required', false);
            }
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\faketaxi\resources\views/admin/reports/user_report.blade.php ENDPATH**/ ?>