<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Models\User;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\IngredientsController;
use App\Http\Controllers\FoodCategoriesController;
use App\Http\Controllers\FoodItemController;

Route::post('/register', [AuthController::class, 'register']); //Register API
Route::post('/login', [AuthController::class, 'login']); //Login API

Route::group(['middleware' => ['auth:sanctum']], function(){

    Route::post('/logout', [AuthController::class, 'logout']); //Logout API
    Route::get('/me', [AuthController::class, 'me']); //Get Data (For homepage)
    Route::post('/user/update/{id}',[AuthController::class,'update']);
    Route::get('/list', [AuthController::class, 'list']); //All Users Lists (NOT FOR IMPLEMENT)

    Route::post('/recipe/create',[CategoryController::class,'store']); // Create new recipe (NOT FOR IMPLEMENT)
    Route::get('/recipe/all',[CategoryController::class,'index']); // List all recipe

    Route::post('/meal/create',[ProductController::class,'store']); // Create new meal (NOT FOR IMPLEMENT)
    Route::get('/meal/{id}',[ProductController::class,'show']); // List meal data

    Route::post('/ingredient/create',[IngredientsController::class,'store']); // Create new ingredient (NOT FOR IMPLEMENT)

    Route::post('/foodcategory/create',[FoodCategoriesController::class,'store']); // Create new foodcategory (NOT FOR IMPLEMENT)
    Route::get('/foodcategory/all',[FoodCategoriesController::class,'index']); // List all food category
    Route::get('/foodcategory/{id}',[FoodCategoriesController::class,'show']); // List food data
    Route::get('/allfooditems',[FoodCategoriesController::class,'showAll']); // List food data

    Route::post('/fooditem/create',[FoodItemController::class,'store']); // Create new food item (NOT FOR IMPLEMENT)
    Route::get('/fooditem/all',[FoodItemController::class,'index']); // List all food item
    Route::get('/fooditem/{id}',[FoodItemController::class,'show']); // List food data

    // Route::get('/product',[ProductController::class,'index']);
    // Route::post('/product/update/{id}',[ProductController::class,'update']);
    // Route::post('/product/delete/{id}',[ProductController::class,'destroy']);

});