<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\FoodItem;

class FoodItemController extends Controller
{
    public function index()
    {
        $FoodItem = FoodItem::all(['id', 'item as food_item', 'status as status', 'desc as description']);
        return response()->json([
            'success' => true,
            'data' =>  $FoodItem,
            'message' => "All food items"
        ], 200);
    }

    public function store(Request $request)
    {
        $product = FoodItem::create($request->all());
        $data = "Successfully stored the data";
        return response()->json($data, 200);
    }

    public function show($id)
    {
        $product = FoodItem::findorfail($id);
        
        return response()->json([
            'status' => true, 
            'data' => $product,
            'message' => "Food item retrieve successfully!" , 
        ], 200);
    }
}
