<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\FoodCategories;

class FoodCategoriesController extends Controller
{
    public function index()
    {
        $categories = FoodCategories::all();
        
        return response()->json([
            'success' => true,
            'data' => $categories,
            'message' => "All categories of food item."
        ], 200);
    }

    public function show($id)
    {
        $product = FoodCategories::findorfail($id);
        $product->load('details');
        return response()->json([
            'status' => true,
            'data' => $product,
            'message' => "Food item retrieve successfully!",
        ], 200);
    }

    public function showAll()
    {
        $product = FoodCategories::all(['id', 'title as food_item', 'description as description']);
        $product->load('details');
        return response()->json([
            'status' => true,
            'data' => $product,
            'message' => "Food item retrieve successfully!",
        ], 200);
    }

    public function store(Request $request)
    {
        $product = FoodCategories::create($request->all());
        $data = "Successfully stored the data";
        return response()->json($data, 200);
    }
}