<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Categories;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = Categories::all(['id', 'title as category', 'description as description']);
        $categories->load('meal');
        
        return response()->json([
            'success' => true,
            'data' =>  $categories,
            'message' => "All categories with recipe."
        ], 200);
    }

    public function store(Request $request)
    {
        $product = Categories::create($request->all());
        $data = "Successfully stored the data";
        return response()->json($data, 200);
    }
}