<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class AuthController extends Controller
{
    public function register(Request $request)
    {
        $attr = $request->validate([

            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|string|min:6',
            'zipcode' => 'nullable|string',
            'due_date' => 'nullable|date',
            'first_time_parent' => 'nullable|string',

        ]);

        $user = User::create([

            'name' => $attr['name'],
            'email' => $attr['email'],
            'password' => bcrypt($attr['password']),
            'zipcode' => $attr['zipcode'],
            'due_date' => $attr['due_date'],
            'first_time_parent' => $attr['first_time_parent'],

        ]);

        $token = $user->createToken('API Token')->plainTextToken;
        $code = 200;

        return response()->json([

            'success' => true,
            'message' => 'User registered',
            'data' => $user,
            'token' => $token

        ],$code);
    }

    public function login(Request $request)
    {
        $attr = $request->validate([

            'email' => 'required|email',
            'password' => 'required|string|min:6',

        ]);

        if(!Auth::attempt($attr))
        {
            return $this->error('Credentials not match', 401);
        }

        $token = auth()->user()->createToken('API Token')->plainTextToken;
        $user = Auth::user();
        $code = 200;
        return response()->json([

            'success' => true,
            'message' => 'Login successfull',
            'data' => $user,
            'token' => $token
            
        ],$code);
    }

    public function me(Request $request)
    {
        $user = Auth::user();
        $code = 200;

        $date_c = date_create(date("Y-m-d"));
        $date_d = date_create($user->due_date);
        $difference = $date_c->diff($date_d);

        $month = $difference->m;
        $trimester = null;
        $size = null;

        if($month <= 3){

            $trimester = "1st";
            $size = "raspberry";

        }
        
        else if($month > 3 && $month <= 6){

            $trimester = "2nd";
            $size = "raspberry";

        }

        else if($month > 6){

            $trimester = "3rd";
            $size = "raspberry";

        }

        $header_msg = "You're ". $difference->m." months, ". (int)(($difference->days) / 7)." weeks, ".$difference->d." days pregnant. You're in your ".$trimester." Trimester.";
        $body_msg = "Your baby is the size of a ".$size."! In the ".$trimester." trimester, your baby is developing. You should focus on eating this diet.";

        $days = $difference->days . " days.";

        return response()->json([

            'success' => true,
            "data"=> [
                'header message' => $header_msg,
                'body message' => $body_msg,
                'details' => $user,
            
            ],
            "message"=> "All user data",
            
        ],$code);
    }

    public function logout()
    {
        auth()->user()->tokens()->delete();
        $code = 200;
        
        return response()->json([

            'success' => true,
            'message' => 'Logout successfully',

        ],$code);

    }

    public function update(Request $request, $id)
    {    
        $user = User::findorfail($id);

        $validator = Validator::make($request->all(),[
            'name' => 'sometimes|required|string|max:255',
            'password' => 'sometimes|required|string|min:6',
            'zipcode' => 'sometimes|nullable|string',
            'due_date' => 'sometimes|nullable|date',
            'first_time_parent' => 'sometimes|nullable|string',
        ]);

        $data = $request->all();

        $message = 'Fields Required';

        if ($validator->fails()) {
            return $this->sendError($response = [],$message);
        }
        
        if ($request->has('password'))
        {

            $hashedPassword = bcrypt($request->password);
            $data['password'] = $hashedPassword;
        }
        
        $user->fill($data);
        $user->save();

        $code = 200;

        return response()->json([

            'success' => true,
            'message' => 'User update successfully',

        ],$code);

    }
    
    public function list()
    {

        $user = User::get();
        $code = 200;
        return response()->json([

            'success' => true,
            'message' => 'Data Retrieved',
            'data' => $user,

        ],$code);
        
    }

}
