<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class BrandRegistrationOptions {
    /**
     * @param string $brandType Type of brand being created. One of: "STANDARD",
     *                          "STARTER".
     * @return CreateBrandRegistrationOptions Options builder
     */
    public static function create(string $brandType = Values::NONE): CreateBrandRegistrationOptions {
        return new CreateBrandRegistrationOptions($brandType);
    }
}

class CreateBrandRegistrationOptions extends Options {
    /**
     * @param string $brandType Type of brand being created. One of: "STANDARD",
     *                          "STARTER".
     */
    public function __construct(string $brandType = Values::NONE) {
        $this->options['brandType'] = $brandType;
    }

    /**
     * Type of brand being created. One of: "STANDARD", "STARTER". STARTER is for low volume, starter use cases. STANDARD is for all other use cases.
     *
     * @param string $brandType Type of brand being created. One of: "STANDARD",
     *                          "STARTER".
     * @return $this Fluent Builder
     */
    public function setBrandType(string $brandType): self {
        $this->options['brandType'] = $brandType;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Messaging.V1.CreateBrandRegistrationOptions ' . $options . ']';
    }
}