<!DOCTYPE html>

<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Medicore | Medication</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="Preview page of Metronic Admin Theme #1 for bootstrap inputs, input groups, custom checkboxes and radio controls and more" name="description" />
    <meta content="" name="author" />
    <?php echo $__env->make('global.head_links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="shortcut icon" href="favicon.ico" /> 
</head>

    <body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white">
        <div class="page-wrapper">
            <!-- BEGIN HEADER -->
            <?php echo $__env->make('global.top_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- END HEADER -->
            <!-- BEGIN HEADER & CONTENT DIVIDER -->
            <div class="clearfix"> </div>
            <!-- END HEADER & CONTENT DIVIDER -->
            <!-- BEGIN CONTAINER -->
            <div class="page-container">
                <!-- BEGIN SIDEBAR -->
                <?php echo $__env->make('admin.side_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- END SIDEBAR -->
                <!-- BEGIN CONTENT -->
                <div class="page-content-wrapper">
                    <!-- BEGIN CONTENT BODY -->
                    <div class="page-content">
                        <!-- BEGIN PAGE HEADER-->
               
                        <!-- BEGIN PAGE BAR -->
                        <div class="page-bar">
                            <ul class="page-breadcrumb">
                                <li>
                                    <a href="#">Home</a>
                                    <i class="fa fa-circle"></i>
                                </li>
                                <li>
                                    <span>Medication</span>
                                </li>
                            </ul>
                        </div>
                        <!-- END PAGE BAR -->
                        <!-- BEGIN PAGE TITLE-->
                        <h1 class="page-title">Medication</h1>
                        <!-- END PAGE TITLE-->
                        <!-- END PAGE HEADER-->

                        <div class="row">
                            <div class="col-md-12">
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption">
                                            <i class="icon-equalizer font-red-sunglo"></i>
                                            <span class="caption-subject font-red-sunglo bold uppercase">Add Medication</span>
                                        </div>
                                    </div>
                                    <div class="portlet-body form">
                                        <!-- BEGIN FORM-->
                                        <form class="form-horizontal" action="/admin/medication/store" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <div class="form-body">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">Patient Code
                                                        <span class="required"> * </span>
                                                    </label>
                                                    <div class="col-md-4">
                                                        <select id="single" name="patient_code" class="form-control select2" required="true">
                                                            <option></option>
                                                            <?php $__currentLoopData = $patient; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($data->id); ?>"><?php echo e($data->patient_code); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <span class="help-block"> Enter Patient Code </span>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">RX name
                                                        <span class="required"> * </span>
                                                    </label>
                                                    <div class="col-md-4">
                                                        <input type="text" class="form-control" name="rx_name" />
                                                        <span class="help-block"> Enter RX Name </span>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">RX Prescribed Dosage
                                                        <span class="required"> * </span>
                                                    </label>
                                                    <div class="col-md-4">
                                                        <input type="text" class="form-control" name="rx_prescribed_dosage" />
                                                        <span class="help-block"> Enter RX Prescribed Dosage (0.5mg) </span>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">RX Dosing Frequency
                                                        <span class="required"> * </span>
                                                    </label>
                                                    <div class="col-md-4">
                                                        <select id="single" name="rx_dosing_frequency" class="form-control select2 rx_dosing_frequency" required="true">
                                                            <option></option>
                                                            <option value="1">One time a Day</option>
                                                            <option value="2">Two times a Day</option>
                                                            <option value="3">Three times a Day</option>
                                                            <option value="4">Four times a Day</option>
                                                            <option value="5">Five times a Day</option>
                                                            <option value="6">Six times a Day</option>
                                                            <option value="7">Seven times a Day</option>
                                                            <option value="8">Eight times a Day</option>
                                                            <option value="9">Nine times a Day</option>
                                                            <option value="10">Ten times a Day</option>
                                                        </select>
                                                        <span class="help-block"> Select RX Dosing Frequency </span>
                                                    </div>
                                                </div>
                                                <div class="form-group rx_dose_time_div">
                                                    
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">Day Gap
                                                        <span class="required"> * </span>
                                                    </label>
                                                    <div class="col-md-4">
                                                        <select id="single" name="day_gap" class="form-control select2 day_gap" required="true">
                                                            <option></option>
                                                            <option value="1">One Day</option>
                                                            <option value="2">Two Days</option>
                                                            <option value="3">Three Days</option>
                                                            <option value="4">Four Days</option>
                                                            <option value="5">Five Days</option>
                                                            <option value="6">Six Days</option>
                                                            <option value="7">Seven Days</option>
                                                            <option value="8">Eight Days</option>
                                                            <option value="9">Nine Days</option>
                                                            <option value="10">Ten Days</option>
                                                        </select>
                                                        <span class="help-block"> Select Day Gap </span>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">Initial Dose
                                                        <span class="required"> * </span>
                                                    </label>
                                                    <div class="col-md-4">
                                                        <input type="text" pattern="[0-9]{1,5}" class="form-control" name="initial_dose" placeholder="Only in numbers e.g. 2" />
                                                        <span class="help-block"> Enter Initial Dose (2 dose at one time) </span>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">Dose Stock
                                                        <span class="required"> * </span>
                                                    </label>
                                                    <div class="col-md-4">
                                                        <input type="text" pattern="[0-9]{1,5}" class="form-control" name="stock_quantity" placeholder="Only in numbers e.g. 50" />
                                                        <span class="help-block"> Enter Dose Stock (50 dose) </span>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">Dose Start Date
                                                        <span class="required"> * </span>
                                                    </label>
                                                    <div class="col-md-4">
                                                        <input type="date" class="form-control" name="dose_start_date" />
                                                        <span class="help-block"> Enter Dose Start Date </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-actions">
                                                <div class="row">
                                                    <div class="col-md-offset-3 col-md-4">
                                                        <button type="submit" name="submit" class="btn green button-submit">Submit</button>
                                                        <button type="button" class="btn default">Cancel</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                        <!-- END FORM-->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- END CONTENT BODY -->
                </div>
                <!-- END CONTENT -->
            </div>
            <!-- END CONTAINER -->
            <!-- BEGIN FOOTER -->
            <?php echo $__env->make('global.footer_content', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- END FOOTER -->
        </div>
        <!-- BEGIN QUICK NAV -->

        <!-- END QUICK NAV -->
        <?php echo $__env->make('global.footer_links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <script>
            $(document).ready(function()
            {
                $('#clickmewow').click(function()
                {
                    $('#radio1003').attr('checked', 'checked');
                });
            })
        </script>
</body>
</html><?php /**PATH /home/gologonowapp/public_html/medicorehealth/resources/views/admin/medication/index.blade.php ENDPATH**/ ?>