<!DOCTYPE html>

<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Medicore | Patient</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="Preview page of Metronic Admin Theme #1 for bootstrap inputs, input groups, custom checkboxes and radio controls and more" name="description" />
    <meta content="" name="author" />
    <?php echo $__env->make('global.head_links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="shortcut icon" href="favicon.ico" /> 
</head>

    <body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white">
        <div class="page-wrapper">
            <!-- BEGIN HEADER -->
            <?php echo $__env->make('global.top_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- END HEADER -->
            <!-- BEGIN HEADER & CONTENT DIVIDER -->
            <div class="clearfix"> </div>
            <!-- END HEADER & CONTENT DIVIDER -->
            <!-- BEGIN CONTAINER -->
            <div class="page-container">
                <!-- BEGIN SIDEBAR -->
                <?php echo $__env->make('admin.side_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- END SIDEBAR -->
                <!-- BEGIN CONTENT -->
                <div class="page-content-wrapper">
                    <!-- BEGIN CONTENT BODY -->
                    <div class="page-content">
                        <!-- BEGIN PAGE HEADER-->
               
                        <!-- BEGIN PAGE BAR -->
                        <div class="page-bar">
                            <ul class="page-breadcrumb">
                                <li>
                                    <a href="#">Home</a>
                                    <i class="fa fa-circle"></i>
                                </li>
                                <li>
                                    <span>Patient List</span>
                                </li>
                            </ul>
                        </div>
                        <!-- END PAGE BAR -->
                        <!-- BEGIN PAGE TITLE-->
                        <h1 class="page-title">Patient List</h1>
                        <!-- END PAGE TITLE-->
                        <!-- END PAGE HEADER-->
                        <div class="row">
                            <div class="col-md-12">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase"> List</span>
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <div class="table-toolbar">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="btn-group">
                                                        <a href="/admin/patient/add" class="btn green">Add new Patient <i class="fa fa-plus"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <table class="table table-striped table-bordered table-hover dt-responsive" id="sample_2">
                                            <thead>
                                                <tr>
                                                   
                                                    <th> Firstname </th>
                                                    <th> Lastname </th>
                                                    <th> Patient Code </th>
                                                    <th> Gender </th>
                                                    <th> Content </th>
                                                    <th> Emergency Contact </th>
                                                    <th> Address </th>
                                                    <th> City </th>
                                                    <th> State </th>
                                                    <th class="none">Caregiver Name: </th>
                                                    <th class="none">Caregiver Relation: </th>
                                                    <th class="none">Caregiver Gender: </th>
                                                    <th class="none">Caregiver Contact: </th>

                                                    <th class="none">Follower Name: </th>
                                                    <th class="none">Follower Relation: </th>
                                                    <th class="none">Follower Gender: </th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                                <?php $__currentLoopData = $patient; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr class="odd gradeX">
                                                       
                                                        <td> <?php echo e($data->firstname); ?> </td>
                                                        <td> <?php echo e($data->lastname); ?> </td>
                                                        <td> <?php echo e($data->patient_code); ?> </td>
                                                        <td> <?php echo e($data->gender); ?> </td>
                                                        <td> <?php echo e($data->contact); ?> </td>
                                                        <td> <?php echo e($data->emergency_contact); ?> </td>
                                                        <td> <?php echo e($data->address); ?> </td>
                                                        <td> <?php echo e($data->city); ?> </td>
                                                        <td> <?php echo e($data->state); ?> </td>
                                                        <td> <?php echo e($data->caregiver->firstname.' '.$data->caregiver->lastname); ?></td>
                                                        <td> <?php echo e($data->caregiver->relation); ?></td>
                                                        <td> <?php echo e($data->caregiver->gender); ?></td>
                                                        <td> <?php echo e($data->caregiver->contact); ?></td>

                                                        <td> <?php echo e($data->follower->firstname.' '.$data->caregiver->lastname); ?></td>
                                                        <td> <?php echo e($data->follower->relation); ?></td>
                                                        <td> <?php echo e($data->follower->gender); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                    </div>
                    <!-- END CONTENT BODY -->
                </div>
                <!-- END CONTENT -->
            </div>
            <!-- END CONTAINER -->
            <!-- BEGIN FOOTER -->
            <?php echo $__env->make('global.footer_content', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- END FOOTER -->
        </div>
        <!-- BEGIN QUICK NAV -->

        <!-- END QUICK NAV -->
        <?php echo $__env->make('global.footer_links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <script>
            $(document).ready(function()
            {
                $('#clickmewow').click(function()
                {
                    $('#radio1003').attr('checked', 'checked');
                });
            })
        </script>
</body>
</html><?php /**PATH /home/gologonowapp/public_html/medicorehealth/resources/views/admin/patient/index.blade.php ENDPATH**/ ?>