<!DOCTYPE html>

<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Medicore | Stock</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="Preview page of Metronic Admin Theme #1 for bootstrap inputs, input groups, custom checkboxes and radio controls and more" name="description" />
    <meta content="" name="author" />
    <?php echo $__env->make('global.head_links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="shortcut icon" href="favicon.ico" /> 
</head>

    <body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white">
        <div class="page-wrapper">
            <!-- BEGIN HEADER -->
            <?php echo $__env->make('global.top_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- END HEADER -->
            <!-- BEGIN HEADER & CONTENT DIVIDER -->
            <div class="clearfix"> </div>
            <!-- END HEADER & CONTENT DIVIDER -->
            <!-- BEGIN CONTAINER -->
            <div class="page-container">
                <!-- BEGIN SIDEBAR -->
                <?php echo $__env->make('admin.side_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- END SIDEBAR -->
                <!-- BEGIN CONTENT -->
                <div class="page-content-wrapper">
                    <!-- BEGIN CONTENT BODY -->
                    <div class="page-content">
                        <!-- BEGIN PAGE HEADER-->
               
                        <!-- BEGIN PAGE BAR -->
                        <div class="page-bar">
                            <ul class="page-breadcrumb">
                                <li>
                                    <a href="#">Home</a>
                                    <i class="fa fa-circle"></i>
                                </li>
                                <li>
                                    <span>Stock</span>
                                </li>
                            </ul>
                        </div>
                        <!-- END PAGE BAR -->
                        <!-- BEGIN PAGE TITLE-->
                        <h1 class="page-title">Stock</h1>
                        <!-- END PAGE TITLE-->
                        <!-- END PAGE HEADER-->

                        <div class="row">
                            <div class="col-md-12">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase"> Stock List</span>
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover table-checkable order-column">
                                            <thead>
                                                <tr>
                                                    <th>
                                                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                                            <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes" />
                                                            <span></span>
                                                        </label>
                                                    </th>
                                                    <th> Rx Name </th>
                                                    <th> Rx Prescribed Dosage </th>
                                                    <th> Rx Dosing Frequency </th>
                                                    <th> Day Gap </th>
                                                    <th> Initial Dose </th>
                                                    <th> Dose Start Date </th>
                                                    <th> Last Updated Date </th>
                                                    <th> Stock Quantity </th>
                                                    <th> Action </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $stock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                    <?php $__currentLoopData = $data->medications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $medications): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <form class="form-horizontal" action="<?php echo e(route('admin.updateStock', ['id' => $medications->id ])); ?>" id="submit_form" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <tr class="odd gradeX">
                                                            <td>
                                                                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                                                    <input type="checkbox" class="checkboxes" value="1" />
                                                                    <span></span>
                                                                </label>
                                                            </td>
                                                            <td> <?php echo e($medications->rx_name); ?> </td>
                                                            <td> <?php echo e($medications->rx_prescribed_dosage); ?> </td>
                                                            <td> <?php echo e($medications->rx_dosing_frequency); ?> </td>
                                                            <td> <?php echo e($medications->day_gap); ?> day </td>
                                                            <td> <?php echo e($medications->initial_dose); ?> dose </td>
                                                            <td> <?php echo e($medications->dose_start_date); ?> </td>
                                                            <td> <?php echo e($medications->update_date); ?> </td>
                                                            <td> <input class="form-control" type="text" pattern="[0-9]{1,5}" value="<?php echo e($medications->stocks->quantity); ?>" name="stock_qty" />  </td>
                                                            <td> <button type="submit" class="btn yellow button-submit">Update</button></td>
                                                        </tr>
                                                    </form>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                    </div>
                    <!-- END CONTENT BODY -->
                </div>
                <!-- END CONTENT -->
            </div>
            <!-- END CONTAINER -->
            <!-- BEGIN FOOTER -->
            <?php echo $__env->make('global.footer_content', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- END FOOTER -->
        </div>
    
        <!-- BEGIN QUICK NAV -->

        <!-- END QUICK NAV -->
        <?php echo $__env->make('global.footer_links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <script>
            $(document).ready(function()
            {
                $('#clickmewow').click(function()
                {
                    $('#radio1003').attr('checked', 'checked');
                });
            })
        </script>
</body>
</html><?php /**PATH /home/gologonowapp/public_html/medicorehealth/resources/views/admin/stock/show.blade.php ENDPATH**/ ?>