<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\MedicationController;
use App\Http\Controllers\PatientController;
use App\Http\Controllers\StockController;

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('login');
});

Route::get('/login', [AuthController::class, 'index'])->name('login');
Route::post('/validate', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout']);

Route::prefix('admin')->name('admin.')->group(function () {

    Route::middleware(['auth','role:Admin'])->group(function () {

        Route::get('/patient', [PatientController::class, 'index']);
        Route::get('/patient/add', [PatientController::class, 'add'])->name('addPatient');
        Route::post('/patient/store', [PatientController::class, 'store']);

        Route::get('/medication', [MedicationController::class, 'index']);
        Route::post('/medication/store', [MedicationController::class, 'store']);

        Route::get('/stock', [StockController::class, 'index']);
        Route::get('/stock/show/{id}', [StockController::class, 'show'])->name('showStock');
        Route::post('/stock/update/{id}', [StockController::class, 'update'])->name('updateStock');
    
    });

});