<?php

use App\Http\Controllers\Api\AppController;
use App\Http\Controllers\Api\AuthController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('login', [AuthController::class, 'login']);

Route::group(['middleware' => ['auth:sanctum']], function(){

    Route::post('/logout', [AuthController::class, 'logout']); //Logout API

    Route::get('/bodyParts', [AppController::class, 'bodyParts']);
    Route::get('/painTypes', [AppController::class, 'painTypes']);
    Route::get('/rxName', [AppController::class, 'rxName']);
    Route::get('/rxName/{id}', [AppController::class, 'singleRx']);
    Route::get('/symptoms', [AppController::class, 'symptoms']);

    Route::post('/painReport', [AppController::class, 'painReport']);
    Route::post('/rxIntake', [AppController::class, 'rxIntake']);
    
});