<!DOCTYPE html>

<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Medicore | Patient</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="Preview page of Metronic Admin Theme #1 for bootstrap inputs, input groups, custom checkboxes and radio controls and more" name="description" />
    <meta content="" name="author" />
    @include('global.head_links')
    <link rel="shortcut icon" href="favicon.ico" /> 
</head>

    <body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white">
        <div class="page-wrapper">
            <!-- BEGIN HEADER -->
            @include('global.top_bar')
            <!-- END HEADER -->
            <!-- BEGIN HEADER & CONTENT DIVIDER -->
            <div class="clearfix"> </div>
            <!-- END HEADER & CONTENT DIVIDER -->
            <!-- BEGIN CONTAINER -->
            <div class="page-container">
                <!-- BEGIN SIDEBAR -->
                @include('admin.side_bar')
                <!-- END SIDEBAR -->
                <!-- BEGIN CONTENT -->
                <div class="page-content-wrapper">
                    <!-- BEGIN CONTENT BODY -->
                    <div class="page-content">
                        <!-- BEGIN PAGE HEADER-->
               
                        <!-- BEGIN PAGE BAR -->
                        <div class="page-bar">
                            <ul class="page-breadcrumb">
                                <li>
                                    <a href="#">Home</a>
                                    <i class="fa fa-circle"></i>
                                </li>
                                <li>
                                    <span>Patient List</span>
                                </li>
                            </ul>
                        </div>
                        <!-- END PAGE BAR -->
                        <!-- BEGIN PAGE TITLE-->
                        <h1 class="page-title">Patient List</h1>
                        <!-- END PAGE TITLE-->
                        <!-- END PAGE HEADER-->
                        <div class="row">
                            <div class="col-md-12">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase"> List</span>
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <div class="table-toolbar">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="btn-group">
                                                        <a href="/admin/patient/add" class="btn green">Add new Patient <i class="fa fa-plus"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <table class="table table-striped table-bordered table-hover dt-responsive" id="sample_2">
                                            <thead>
                                                <tr>
                                                   
                                                    <th> Firstname </th>
                                                    <th> Lastname </th>
                                                    <th> Patient Code </th>
                                                    <th> Gender </th>
                                                    <th> Content </th>
                                                    <th> Emergency Contact </th>
                                                    <th> Address </th>
                                                    <th> City </th>
                                                    <th> State </th>
                                                    <th class="none">Caregiver Name: </th>
                                                    <th class="none">Caregiver Relation: </th>
                                                    <th class="none">Caregiver Gender: </th>
                                                    <th class="none">Caregiver Contact: </th>

                                                    <th class="none">Follower Name: </th>
                                                    <th class="none">Follower Relation: </th>
                                                    <th class="none">Follower Gender: </th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                                @foreach ($patient as $data)
                                                    <tr class="odd gradeX">
                                                       
                                                        <td> {{$data->firstname}} </td>
                                                        <td> {{$data->lastname}} </td>
                                                        <td> {{$data->patient_code}} </td>
                                                        <td> {{$data->gender}} </td>
                                                        <td> {{$data->contact}} </td>
                                                        <td> {{$data->emergency_contact}} </td>
                                                        <td> {{$data->address}} </td>
                                                        <td> {{$data->city}} </td>
                                                        <td> {{$data->state}} </td>
                                                        <td> {{$data->caregiver->firstname.' '.$data->caregiver->lastname}}</td>
                                                        <td> {{$data->caregiver->relation}}</td>
                                                        <td> {{$data->caregiver->gender}}</td>
                                                        <td> {{$data->caregiver->contact}}</td>

                                                        <td> {{$data->follower->firstname.' '.$data->caregiver->lastname}}</td>
                                                        <td> {{$data->follower->relation}}</td>
                                                        <td> {{$data->follower->gender}}</td>
                                                    </tr>
                                                @endforeach

                                                {{-- <tr class="odd gradeX">
                                                    <td>
                                                        <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                                            <input type="checkbox" class="checkboxes" value="1" />
                                                            <span></span>
                                                        </label>
                                                    </td>
                                                    <td> shuxer </td>
                                                    <td>
                                                        <a href="mailto:shuxer@gmail.com"> shuxer@gmail.com </a>
                                                    </td>
                                                    <td>
                                                        <span class="label label-sm label-success"> Approved </span>
                                                    </td>
                                                    <td class="center"> 12 Jan 2012 </td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <button class="btn btn-xs green dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false"> Actions
                                                                <i class="fa fa-angle-down"></i>
                                                            </button>
                                                            <ul class="dropdown-menu pull-left" role="menu">
                                                                <li>
                                                                    <a href="javascript:;">
                                                                        <i class="icon-docs"></i> New Post </a>
                                                                </li>
                                                                <li>
                                                                    <a href="javascript:;">
                                                                        <i class="icon-tag"></i> New Comment </a>
                                                                </li>
                                                                <li>
                                                                    <a href="javascript:;">
                                                                        <i class="icon-user"></i> New User </a>
                                                                </li>
                                                                <li class="divider"> </li>
                                                                <li>
                                                                    <a href="javascript:;">
                                                                        <i class="icon-flag"></i> Comments
                                                                        <span class="badge badge-success">4</span>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </td>
                                                </tr> --}}
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                    </div>
                    <!-- END CONTENT BODY -->
                </div>
                <!-- END CONTENT -->
            </div>
            <!-- END CONTAINER -->
            <!-- BEGIN FOOTER -->
            @include('global.footer_content')
            <!-- END FOOTER -->
        </div>
        <!-- BEGIN QUICK NAV -->

        <!-- END QUICK NAV -->
        @include('global.footer_links')
        
        <script>
            $(document).ready(function()
            {
                $('#clickmewow').click(function()
                {
                    $('#radio1003').attr('checked', 'checked');
                });
            })
        </script>
</body>
</html>