<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $rec = [
            [
                'username' => 'superadmin',
                'email' => 'superadmin@gmail.com',
                'password' => Hash::make('123456'),
                'role' => 'Super Admin'
            ],
            [
                'username' => 'admin',
                'email' => 'admin@gmail.com',
                'password' => Hash::make('123456'),
                'role' => 'Admin'
            ],
            [
                'username' => 'self reporter',
                'email' => 'selfreporter@gmail.com',
                'password' => Hash::make('123456'),
                'role' => 'Self Reporter'
            ],
            [
                'username' => 'caregiver',
                'email' => 'caregiver@gmail.com',
                'password' => Hash::make('123456'),
                'role' => 'Caregiver'
            ],
            [
                'username' => 'follower',
                'email' => 'follower@gmail.com',
                'password' => Hash::make('123456'),
                'role' => 'Follower'
              ],
          ];
  
          foreach ($rec as $key => $value) {
              
              $user = User::create(['username' => $value['username'],'email' => $value['email'],'password' => $value['password']]);
              $role = Role::create(['name' => $value['role']]);
              $permissions = Permission::pluck('id','id')->all();
              $role->syncPermissions($permissions);
              $user->assignRole([$role->id]);
  
          }
    }
}
