<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIntakeReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('intake_reports', function (Blueprint $table) {
            $table->id();
            $table->integer('patient_id');
            $table->integer('medication_id');
            $table->date('intake_date');
            $table->integer('quantity');
            $table->boolean('refill');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('intake_reports');
    }
}
