<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePainReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pain_reports', function (Blueprint $table) {
            $table->id();
            $table->integer('patient_id');
            $table->boolean('pain'); //0 for existing / 1 for new
            $table->integer('pain_level'); //0 to 10
            $table->integer('pain_type'); //pain id
            $table->integer('body_part'); //bodypart id
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pain_reports');
    }
}
