<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMedicationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('medications', function (Blueprint $table) {
            $table->id();
            $table->integer('patient_id');
            $table->string('rx_name');
            $table->string('rx_prescribed_dosage'); //0.5mg
            $table->string('rx_dosing_frequency'); //3 times a day
            $table->integer('day_gap'); //1 days
            $table->integer('initial_dose');
            $table->date('dose_start_date');
            $table->date('update_date');
            $table->boolean('status')->default(1); //0 / 1
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {   
        Schema::dropIfExists('medications');
    }
}
