<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Patient extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'firstname',
        'lastname',
        'gender',
        'contact',
        'emergency_contact',
        'patient_code',
        'address',
        'city',
        'state',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, "user_id", "id");
    }

    public function caregiver()
    {
        return $this->hasOne(Caregiver::class, "patient_id", "id");
    }

    public function follower()
    {
        return $this->hasOne(Follower::class, "patient_id", "id");
    }

    public function medications()
    {
        return $this->hasMany(Medication::class, "patient_id", "id");
    }
}
