<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Medication extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'patient_id',
        'rx_name',
        'rx_prescribed_dosage',
        'rx_dosing_frequency',
        'day_gap',
        'initial_dose',
        'dose_start_date',
        'update_date',
        'status'
    ];
    
    public function doesTimings()
    {
        return $this->hasMany(DoseTiming::class, "medication_id", "id");
    }

    public function stocks()
    {
        return $this->hasOne(DoseStock::class, "medication_id", "id");
    }
}
