<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Follower extends Model
{
    use HasFactory;

    protected $fillable = [
    
        'user_id',
        'patient_id',
        'firstname',
        'lastname',
        'gender',
        'relation',
    
    ];

    public function user()
    {
        return $this->belongsTo(User::class, "user_id", "id");
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, "user_id", "id");
    }
}
