<?php

namespace App\Http\Controllers;

use App\Models\DoseStock;
use App\Models\Patient;
use Illuminate\Http\Request;

class StockController extends Controller
{
    public function index()
    {
        $patient = Patient::get();
        $data['patient'] = $patient;
        return view('admin.stock.index', $data);
    }

    public function show($id)
    {
        $patient = Patient::with('medications.stocks')->where('id',$id)->get();
        $data['stock'] = $patient;
        return view('admin.stock.show', $data);
    }

    public function update(Request $request, $id)
    {
        $stock = DoseStock::find($id);

        if($stock) {

            $stock->quantity = $request->stock_qty;
            $stock->save();
            
            return redirect()->back()->with('message', 'Stock updated');

        }
    }
}