<?php

namespace App\Http\Controllers;

use App\Models\BodyPart;
use App\Models\Caregiver;
use App\Models\DoseStock;
use App\Models\DoseTiming;
use App\Models\Follower;
use App\Models\Medication;
use App\Models\PainReport;
use App\Models\PainType;
use App\Models\Patient;
use App\Models\SypmtomType;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Spatie\Permission\Models\Role;

class PatientController extends Controller
{
    public function index()
    {
        $patient = Patient::with('caregiver')->with('follower')->get();
        $data['patient'] = $patient;
        return view('admin.patient.index', $data);
    }
    
    public function add()
    {
        $bodyParts = BodyPart::get();
        $data['bodyParts'] = $bodyParts;
        return view('admin.patient.add', $data);
    }
    
    public function store(Request $request)
    {
        $id = 0;

        $id = $this->createAccounts($request->p_email, 'Self Reporter login credentials', 'Self Reporter');
        if( $id > 0 )
        {
            $patient = Patient::create([

                'user_id' => $id,
                'firstname' => $request->firstname,
                'lastname' => $request->lastname,
                'gender' => $request->gender,
                'contact' => $request->contact,
                'emergency_contact' => $request->emrg_contact,
                'patient_code' => $request->patient_code,
                'address' => $request->address,
                'city' => $request->city,
                'state' => $request->state,

            ]);
            
            if($patient)
            {
                $id = $this->createAccounts($request->cg_email, 'Caregiver login credentials', 'Caregiver');
                if( $id > 0 )
                {
                    $caregiver = Caregiver::create([

                        'user_id' => $id,
                        'patient_id' => $patient->id,
                        'firstname' => $request->cg_firstname,
                        'lastname' => $request->cg_lastname,
                        'gender' => $request->cg_gender,
                        'contact' => $request->cg_contact,
                        'relation' => $request->cg_relation,

                    ]);

                    if($caregiver)
                    {
                        $id = $this->createAccounts($request->follower_email, 'Follower login credentials', 'Follower');
                        if( $id > 0 )
                        {
                            $follower = Follower::create([

                                'user_id' => $id,
                                'patient_id' => $patient->id,
                                'firstname' => $request->follower_firstname,
                                'lastname' => $request->follower_lastname,
                                'gender' => $request->follower_gender,
                                'relation' => $request->follower_relation,

                            ]);

                            if($follower)
                            {
                                $pain = PainType::create([
    
                                    'patient_id' => $patient->id,
                                    'types' => $request->pain_type

                                ]);

                                if($pain)
                                {
                                    $pain_report = PainReport::create([

                                        'patient_id' => $patient->id,
                                        'pain' => 1,
                                        'pain_level' => $request->pain_level,
                                        'pain_type' => $pain->id,
                                        'body_part' => $request->body_part

                                    ]);
                                    
                                    if($pain_report)
                                    {
                                        $side_effects_arr = preg_split ("/\,/", $request->side_effects); 
                                
                                        if(count($side_effects_arr) > 0)
                                        {
                                            for ($i=0; $i < count($side_effects_arr); $i++) { 
                                    
                                                $side_effects = SypmtomType::create([
            
                                                    'patient_id' => $patient->id,
                                                    'sypmtoms' => $side_effects_arr[$i]       
            
                                                ]);
                                                
                                            }

                                            if($side_effects)
                                            {
                                                return redirect()->back()->with('message', 'Patient Added!');
                                            }
                                            else
                                            {
                                                return redirect()->back()->with('error', 'Error with Side Effects!');
                                            }
                                        }
                                        else
                                        {
                                            return redirect()->back()->with('message', 'Patient Added!');
                                        }
                                    }
                                    else
                                    {
                                        return redirect()->back()->with('error', 'Error with Pain Report!');
                                    }
                                }
                                else
                                {
                                    return redirect()->back()->with('error', 'Error with Pain!');
                                }
                            }
                            else
                            {
                                return redirect()->back()->with('error', 'Error in Follower!');
                            }
                        }
                        else
                        {
                            return redirect()->back()->with('error', 'Error in Follower!');
                        }
                    }
                    else
                    {
                        return redirect()->back()->with('error', 'Error in Caregiver!');
                    }
                }
                else
                {
                    return redirect()->back()->with('error', 'Error in Caregiver!');
                }
            }
            else
            {
                return redirect()->back()->with('error', 'Error in Self Reporter!');
            }
        }
        else
        {
            return redirect()->back()->with('error', 'Error in Self Reporter!');
        }
    }

    public function createAccounts($email, $title, $role)
    {
        $password = mt_rand(1000, 9999);
        $user = User::create([

            'username' => strtok($email, '@'),
            'email' => $email,
            'password' => Hash::make($password),

        ]);

        $role = Role::where('name' , $role)->first();
        $user->assignRole([$role->id]);

        $details = [
            'title' => $title,
            'body' => 'Email: '.$email.', Password: '.$password,
        ];
       
        \Mail::to($email)->send(new \App\Mail\CredentialEmail($details));

        return($user->id);

    }
    
}