<?php

namespace App\Http\Controllers;

use App\Models\DoseStock;
use App\Models\DoseTiming;
use App\Models\Medication;
use App\Models\Patient;
use Illuminate\Http\Request;

class MedicationController extends Controller
{
    public function index()
    {
        $patient = Patient::get();
        $data['patient'] = $patient;
        return view('admin.medication.index', $data);
    }

    public function store(Request $request)
    {
        $medication = Medication::create([

            'patient_id' => $request->patient_code,
            'rx_name' => $request->rx_name,
            'rx_prescribed_dosage' => $request->rx_prescribed_dosage,
            'rx_dosing_frequency' => $request->rx_dosing_frequency.' times a day',
            'day_gap' => $request->day_gap,
            'initial_dose' => $request->initial_dose,
            'dose_start_date' => $request->dose_start_date,
            'update_date' => $request->dose_start_date,
            'status' => 1

        ]);

        $doseStock = DoseStock::create([

            'medication_id' => $medication->id,
            'quantity' => $request->stock_quantity,

        ]);

        for ($i=1; $i <= count($request->rx_dose_time); $i++) { 

            $doseTimings = DoseTiming::create([

                'medication_id' => $medication->id,
                'dose_time' => $request->rx_dose_time[$i],

            ]);

        }

        return redirect()->back()->with('message', 'Medication Added!');
    }
}
