<?php

namespace App\Http\Controllers;

use App\Models\Patient;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Contracts\Session\Session;

use Spatie\Permission\Models\Role;


class AuthController extends Controller
{
    public function index()
    {
        return view('login');
    }

    public function login(Request $request)
    {
        $credentials = $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        // $checkRole = User::where('email', $request->email)->first();
        // dd($checkRole->roles[0]['name']);

        if (Auth::attempt($credentials)) {
            
            $user = Auth::user();
            $request->session()->regenerate();

            $user->save();

            if ($user->hasRole('Admin'))
            {
                return redirect()->route('admin.addPatient');
            }
            else
            {
                return back()->with(['error' => 'Only admins can login to the dashboard!']);  
            }
            
        }
        else
        {
            return back()->with(['error' => 'Invalid email address or password!']);  
        }
        
    }

    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect('/login');
    }
}
