<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class AuthController extends Controller
{

    public function login(Request $request)
    {
        $attr = $request->validate([

            'email' => 'required|string|email|',
            'password' => 'required|string|min:4'

        ]);

        if (!Auth::attempt($attr)) {

            return response()->json([

                'success' => false,
                'message' => 'Credentials not match.',
                
            ],401);
        }

        $token = auth()->user()->createToken('API Token')->plainTextToken;
        $user = Auth::user();
        $user->role = $user->roles->pluck('name');

        return response()->json([

            'success' => true,
            'message' => 'Login successfull.',
            'data' => $user,
            'token' => $token
            
        ],200);
    }

    public function logout()
    {
        if(auth()->user()->tokens()->delete())
        {
            return response()->json([

                'success' => true,
                'message' => 'Logout successfully.',

            ],200);
        }
    }

}