<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\BodyPart;
use App\Models\Caregiver;
use App\Models\Follower;
use App\Models\IntakeReport;
use App\Models\Medication;
use App\Models\PainReport;
use App\Models\PainType;
use App\Models\Patient;
use App\Models\RefillRequest;
use App\Models\SypmtomReport;
use App\Models\SypmtomType;
use App\Models\User;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AppController extends Controller
{
    public function patient_id()
    {
        $patient_id = 0;

        $user = Auth::user();

        if($user->roles[0]['name'] == 'Self Reporter')
        {
            $patient_id = Patient::where('user_id', $user->id)->first('id');
        }
        else if($user->roles[0]['name'] == 'Caregiver')
        {
            $patient_id = Caregiver::where('user_id', $user->id)->first('patient_id');
        }
        else if($user->roles[0]['name'] == 'Follower')
        {
            $patient_id = Follower::where('user_id', $user->id)->first('patient_id');
        }
        
        return $patient_id;
    }

    public function bodyParts()
    {
        $bodyParts = BodyPart::get();
        return response()->json([
        
            'success' => true,
            'data' => $bodyParts,
            'message' => 'Body part list.',
            
        ],200);
    }

    public function painTypes()
    {
        $painTypes = PainType::where('patient_id', $this->patient_id()->id)->get();
        return response()->json([
        
            'success' => true,
            'data' => $painTypes,
            'message' => 'Pain type list.',
            
        ],200);
    }

    public function rxName()
    {
        $rxName = Medication::where('patient_id', $this->patient_id()->id)->get(['id', 'rx_name']);
        return response()->json([
        
            'success' => true,
            'data' => $rxName,
            'message' => 'Rx name list.',
            
        ],200);
    }

    public function singleRx($id)
    {
        $rxName = Medication::where('patient_id', $this->patient_id()->id)->where('id', $id)->get();
        return response()->json([
        
            'success' => true,
            'data' => $rxName,
            'message' => 'Rx data.',
            
        ],200);
    }

    public function symptoms()
    {
        $symptoms = SypmtomType::where('patient_id', $this->patient_id()->id)->get();;
        return response()->json([
        
            'success' => true,
            'data' => $symptoms,
            'message' => 'Symptom list.',
            
        ],200);
    }

    public function painReport(Request $request)
    {
        $validator = Validator::make($request->all(),[

            // 'pain' => 'required|integer|min:0|in:0,1', //0 for existing / 1 for new
            'pain_level' => 'required|integer|min:0|max:10',
            'pain_type' => 'integer',
            'pain_type_text' => 'string|min:0|max:255',
            'body_part' => 'required|integer'

        ]);

        $data = $request->all();

        if ($validator->fails()) {
            
            return response()->json([
        
                'success' => false,
                'data' => $validator->errors()
            
            ],422);

        }
        else
        {
            if($request->pain_type != null){

                $painReport = PainReport::create([

                    'patient_id' => $this->patient_id()->id,
                    'pain' => 0,
                    'pain_level' => $data['pain_level'],
                    'pain_type' => $data['pain_type'],
                    'body_part' => $data['body_part'],
    
                ]);

            }
            else
            {
                $painReport = PainType::create([

                    'patient_id' => $this->patient_id()->id,
                    'types' => $data['pain_type_text'],
    
                ]);

                $painReport = PainReport::create([

                    'patient_id' => $this->patient_id()->id,
                    'pain' => 1,
                    'pain_level' => $data['pain_level'],
                    'pain_type' => $painReport->id,
                    'body_part' => $data['body_part'],
    
                ]);

            }
            
            return response()->json([
        
                'success' => true,
                'data' => $painReport,
                'message' => 'Pain report send successfully.',
                
            ],200);
        }
    }

    public function rxIntake(Request $request)
    {

        $validator = Validator::make($request->all(),[

            'medication_id' => 'required|integer',
            'intake_date' => 'required',
            'quantity' => 'required|integer',

        ]);

        $data = $request->all();

        if ($validator->fails()) {
            
            return response()->json([
        
                'success' => false,
                'data' => $validator->errors()
            
            ],422);

        }
        else
        {

            if($request->refill != null)
            {
                $intakeReport = IntakeReport::create([

                    'patient_id' => $this->patient_id()->id,
                    'medication_id' => $data['medication_id'],
                    'intake_date' => $data['intake_date'],
                    'quantity' => $data['quantity'],
                    'refill' => 1,

                ]);

                for ($i=0; $i < count($request->refill); $i++) { 

                    $refillRequest = RefillRequest::create([

                        'intake_id' => $intakeReport->id,
                        'medication_id' => $request->refill[$i],
    
                    ]);

                }

                if($request->old_symptom != null)
                {
                    for ($i=0; $i < count($request->old_symptom); $i++) { 

                        $symptomReport = SypmtomReport::create([

                            'intake_id' => $intakeReport->id,
                            'sypmtom_id' => $request->old_symptom[$i],
                            'description' => 'Lorem ipsum text.'

                        ]);

                    }
                }
                
                if($request->new_symptom != null)
                {
                    for ($i=0; $i < count($request->new_symptom); $i++) { 

                        $symptomType = SypmtomType::create([

                            'patient_id' => $this->patient_id()->id,
                            'sypmtoms' => $request->new_symptom[$i],

                        ]);

                        $symptomReport = SypmtomReport::create([

                            'intake_id' => $intakeReport->id,
                            'sypmtom_id' => $symptomType->id,
                            'description' => 'Lorem ipsum text.'

                        ]);

                    }
                }

                return response()->json([
        
                    'success' => true,
                    'data' => $intakeReport,
                    'message' => 'Intake report send successfully.',
                    
                ],200);

            }
            else
            {

                $intakeReport = IntakeReport::create([

                    'patient_id' => $this->patient_id()->id,
                    'medication_id' => $data['medication_id'],
                    'intake_date' => $data['intake_date'],
                    'quantity' => $data['quantity'],
                    'refill' => 0,

                ]);

                if($request->old_symptom != null)
                {
                    for ($i=0; $i < count($request->old_symptom); $i++) { 

                        $symptomReport = SypmtomReport::create([

                            'intake_id' => $intakeReport->id,
                            'sypmtom_id' => $request->old_symptom[$i],
                            'description' => 'Lorem ipsum text.'

                        ]);

                    }
                }
                
                if($request->new_symptom != null)
                {
                    for ($i=0; $i < count($request->new_symptom); $i++) { 

                        $symptomType = SypmtomType::create([

                            'patient_id' => $this->patient_id()->id,
                            'sypmtoms' => $request->new_symptom[$i],

                        ]);

                        $symptomReport = SypmtomReport::create([

                            'intake_id' => $intakeReport->id,
                            'sypmtom_id' => $symptomType->id,
                            'description' => 'Lorem ipsum text.'

                        ]);

                    }
                }

                return response()->json([
        
                    'success' => true,
                    'data' => $intakeReport,
                    'message' => 'Intake report send successfully.',
                    
                ],200);

            }
        }
        
    }
}