<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\ShopsController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\AttributesController;
use App\Http\Controllers\Rating;
use App\Http\Controllers\WishListConttroller;
use App\Http\Controllers\ShippingChargesController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\AddressController;
use App\Http\Controllers\UserCardsController;
use App\Http\Controllers\ProductPackagesController;
use App\Http\Controllers\PromoCodeController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::post('/gen-group', [ShopsController::class, 'genGroup']);


Route::post('/register', [AuthController::class, 'register']); //Register API
Route::post('/login', [AuthController::class, 'login']); //Login API

Route::get('/getcategories', [ShopsController::class, 'getCategories']);
Route::get('/getshopniche', [ShopsController::class, 'getShopNiche']);
Route::get('/getmetakeys', [ShopsController::class, 'getMetaKeys']);

Route::get('/categorymenu', [SiteController::class, 'categoryMenu']);
Route::post('/subcategorymenu', [SiteController::class, 'subCategoryMenu']);
Route::get('/home-main-cats', [SiteController::class, 'homeMainCats']);



Route::get('/browseshops', [SiteController::class, 'browseShops']);
Route::get('/categorylist', [SiteController::class, 'categoryList']);
Route::get('/productlist', [SiteController::class, 'productList']);
Route::post('/productlist-post', [SiteController::class, 'productListPost']);


Route::get('/product/{id}', [SiteController::class, 'singleProduct']);
Route::post('/product-gallery', [SiteController::class, 'singleProductGallery']);


// home page products
Route::get('/featured/product/list', [SiteController::class, 'featuredProductList']);
Route::get('/recommended/product-list', [SiteController::class, 'recommendedProductList']);
Route::get('/new-collection/product-list', [SiteController::class, 'newCollectionProductList']);


Route::get('/check-product-stocks-get', [CartController::class, 'checkProductInCart']);
Route::post('/check-product-stocks', [CartController::class, 'checkProductInCart']);


// rattings
Route::get('/product-ratings/{id}', [Rating::class, 'productRatingById']);


// shops
Route::get('/new-shops', [ShopsController::class, 'newShop']);
Route::get('/recommended-shop', [ShopsController::class, 'recommendedShop']);
Route::get('/top-shop-trending', [ShopsController::class, 'topShopTrending']);


Route::get('/shop-details', [ShopsController::class, 'shopDetails']);




Route::get('/boost-packages', [ProductPackagesController::class, 'index']);






// Route::get('/add-product-ratings', [Rating::class, 'addProductRating']);

// Main Search Api
Route::get('/main-search', [SiteController::class, 'mainSearch']);
Route::get('/update-category-slugs', [SiteController::class, 'updateSlugs']);



Route::group(['middleware' => ['auth:sanctum','throttle:1,0.008']], function () {

    Route::post('/logout', [AuthController::class, 'logout']); //Logout API

    Route::post('/createshop', [ShopsController::class, 'createShop']);
    Route::post('/addproduct', [ShopsController::class, 'addProduct']);
    Route::post('/addstock', [ShopsController::class, 'addStock']);
    Route::get('/stocklist', [ShopsController::class, 'stockList']);
    Route::get('/allproductlist', [ShopsController::class, 'productList']);


    Route::get('/allproductlistboost-dropdown', [ShopsController::class, 'productListVendorBoosting']);


    Route::post('/addproduct-simple', [ShopsController::class, 'simpleAddProduct']);
    Route::post('/edit-product-simple', [ShopsController::class, 'editSimpleAddProduct']);
    Route::post('/edit-product-variant', [ShopsController::class, 'editVariantProduct']);

    
    

    Route::post('/product/delete/{id}', [ShopsController::class, 'productDelete']);

    Route::get('/singleproductlist', [ShopsController::class, 'singleProductList']);
    Route::post('/singlestocklist', [ShopsController::class, 'singleStockList']);

    Route::post('/updatestock/{id}', [ShopsController::class, 'updateStock']);

    Route::post('/addtocart', [CartController::class, 'addToCart']);
    Route::post('/emptycart', [CartController::class, 'emptyCart']);
    Route::post('/deletecartitem', [CartController::class, 'deleteCartItem']);
    Route::get('/cartlist', [CartController::class, 'cartList']);

    // product attributs
    Route::post('/add-attributes', [AttributesController::class, 'store']);
    Route::get('/product-attributes', [AttributesController::class, 'index']);
    Route::post('/product-attributes-update', [AttributesController::class, 'update']);
    Route::post('/product-attributes-update-option', [AttributesController::class, 'updateOption']);
    Route::get('/attributes-get-option/{option_id}', [AttributesController::class, 'getOptionById']);
    Route::get('/attribute/{attribute_id}', [AttributesController::class, 'getAttributeById']);


    // product stocksviewwOrder
    Route::get('/product/variations/{product_id}', [ShopsController::class, 'getProductStocks']);
    Route::post('/product/update-stocks/{stock_id}', [ShopsController::class, 'updateStocks']);
    Route::get('/new-orders-count', [ShopsController::class, 'countNewOrders']);
    Route::get('/new-orders-status-update', [ShopsController::class, 'updateNewOrdersStatus']);
    Route::get('/vendor-dashboard-data-count', [ShopsController::class, 'vendorDashboardDataCount']);
    Route::get('/customer-dashboard-data-count', [ShopsController::class, 'customerDashboardDataCount']);
    
    

    // product rating
    Route::post('/add-product-rating', [Rating::class, 'addProductRating']);


    // user product wishlist

    Route::get('/user/wishlist', [WishListConttroller::class, 'index']);
    Route::post('/add/user/wishlist', [WishListConttroller::class, 'store']);

    Route::get('/delete/user/wishlist/{id}', [WishListConttroller::class, 'destroy']);



    // user modules
    // users 
    Route::post('/update-users', [AuthController::class, 'updateUsers']);

    // user shop
    Route::get('/user-profile', [AuthController::class, 'userProfile']);
    Route::get('/user-shop', [AuthController::class, 'userShop']);
    Route::post('/update-shop', [ShopsController::class, 'updateShop']);


    Route::get('/boost-packages-list', [ProductPackagesController::class, 'boostList']);
    Route::get('/boost-product-view', [ProductPackagesController::class, 'boostProductView']);
    Route::post('/boost-product', [ProductPackagesController::class, 'boostProduct']);

    

    // add shipping charges
    Route::post('/add-update-shipping-charges', [ShippingChargesController::class, 'store']);
    Route::get('/view-shipping-charges', [ShippingChargesController::class, 'view']);
    
    // checkout 
    Route::post('/checkout-payment', [CartController::class, 'checkoutPayment']);
    //cart check promocode
    Route::post('/vendor/check-promocoe-shop', [CartController::class, 'checkPromocoeShop']);



    // order history
    Route::get('/user-orders', [OrderController::class, 'userOrders']);
    Route::get('/vendor-orders', [OrderController::class, 'vendorOrders']);
    Route::get('/view-order/{id}', [OrderController::class, 'viewOrder']);
    Route::post('/order/status/update', [OrderController::class, 'orderStatusUpdate']);

    // address
    Route::get('/all/address', [AddressController::class, 'index']);
    Route::get('/view/address', [AddressController::class, 'show']);
    Route::post('/add/address', [AddressController::class, 'store']);
    Route::post('/update/address/{id}', [AddressController::class, 'update']);
    Route::post('/destroy/address/{id}', [AddressController::class, 'destroy']);


    // user cards
    Route::post('/users/card/add', [UserCardsController::class, 'create']);
    Route::get('/users/card/list', [UserCardsController::class, 'index']);

    Route::post('/users/card/create', [UserCardsController::class, 'saveUserCard']);
    Route::post('/users/card/delete', [UserCardsController::class, 'deleteserCard']);

    Route::post('/user/logs/save', [SiteController::class, 'userLogsSave']);

    // transaction history

    
    Route::get('/vendor/transaction/history/list', [CartController::class, 'vendorTransactionHistory']);
    Route::get('/vendor/transaction/history/view', [CartController::class, 'vendorTransactionHistoryView']);

    // promo code
    Route::get('/vendor/promocode/list', [PromoCodeController::class, 'index']);
    Route::get('/vendor/promocode/view', [PromoCodeController::class, 'viewPromoCode']);
    Route::post('/vendor/promocode/add', [PromoCodeController::class, 'store']);
    Route::post('/vendor/promocode/update', [PromoCodeController::class, 'updatePromoCode']);

    Route::post('/vendor/promocode/delete', [PromoCodeController::class, 'deletePromoCode']);



    

    
    
});
// Route::get('/vendor/transaction/history/list', [CartController::class, 'vendorTransactionHistory']);