<?php

use App\Http\Controllers\AdminCategoriesController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\{AdminController, AdminProductsController, AdminShopsController , PromoCodeController};

Route::prefix("admin")->group(function () {

    //PRODUCTS
    //get
    Route::get('/all-products', [AdminProductsController::class, 'index']);
    Route::get('/get-product/{id}', [AdminProductsController::class, 'getProduct']);
    Route::get('/shop-products/{id}', [AdminProductsController::class, 'userProducts']);
    Route::get('/products-rating/{id}', [AdminProductsController::class, 'productsRating']);
    Route::get('/products-filter', [AdminProductsController::class, 'productsFilter']);
    //post
    Route::post('/update-product/{id}', [AdminProductsController::class, 'update']);
    //status
    Route::post('/product-status-request', [AdminProductsController::class, 'productStatusUpdate']);

    //CATEGORIES
    //get
    Route::get('/all-categories', [AdminCategoriesController::class, 'index']);
    Route::get('/all-parent-categories', [AdminCategoriesController::class, 'parentCategory']);
    Route::get('/get-category/{id}', [AdminCategoriesController::class, 'getCategory']);
    //get sub-categories
    Route::get('/all-sub-categories', [AdminCategoriesController::class, 'getSubCategories']);
    Route::get('/get-sub-category/{id}', [AdminCategoriesController::class, 'getSingleSubCategory']);
    //post main categories
    Route::post('/update-category/{id}', [AdminCategoriesController::class, 'update']);
    Route::post('/add-category', [AdminCategoriesController::class, 'store']);
    //post sub categories
    Route::post('/add-sub-category', [AdminCategoriesController::class, 'storeSubCategory']);
    Route::post('/edit-sub-category/{id}', [AdminCategoriesController::class, 'updateSubCategory']);
    //status
    Route::post('/category-status-request', [AdminCategoriesController::class, 'categoryStatusUpdate']);
    Route::post('/sub-category-status-request', [AdminCategoriesController::class, 'subCategoryStatusUpdate']);

    //SHOPS
    Route::get('/all-shops', [AdminShopsController::class, 'index']);
    Route::get('/get-shops/{id}', [AdminShopsController::class, 'getShop']);
    Route::post('/update-shops/{id}', [AdminShopsController::class, 'update']);
    //status
    Route::post('/shop-status-request', [AdminShopsController::class, 'shopStatusUpdate']);


    //ORDERS
    Route::get('/all-orders', [AdminController::class, 'orders']);
    Route::get('/shop-orders/{id}', [AdminController::class, 'shopOrders']);
    Route::get('/user-orders/{id}', [AdminController::class, 'userOrders']);
    Route::get('/user-order-details/{id}', [AdminController::class, 'userOrderDetails']);

    //USERS
    Route::get('/all-customers', [AdminController::class, 'customers']);
    Route::post('/user-status-request', [AdminController::class, 'userStatusUpdate']);
    Route::get('/all-vendors', [AdminController::class, 'vendors']);
    Route::get('/user-profile/{id}', [AdminController::class, 'userProfile']);
    Route::get('/shop-profile/{id}', [AdminShopsController::class, 'profileShop']);

    //PROMOS
    Route::get('/all-promos', [AdminController::class, 'promos']);


    Route::get('/vendor/transaction/history/list', [AdminController::class, 'vendorTransactionHistory']);
    Route::get('/vendor/transaction/history/view', [AdminController::class, 'vendorTransactionHistoryView']);

    Route::get('/transaction/all-history', [AdminController::class, 'adminTransactionHistory']);


    

    Route::get('/promocode/list', [PromoCodeController::class, 'adminPromoCodelist']);
    Route::get('/product-boost/list', [AdminProductsController::class, 'productListAdminBoosting']);
    
    


    //DASHBOARD
    Route::get('/dashboard-totals', [AdminController::class, 'dashboardTotals']);

    Route::get('/', function () {
        // return view('welcome');
        return "ASdasd";
    });
});
