<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $rec = [
            [
              'firstname' => 'admin',
              'lastname' => 'default',
              'email' => 'admin@gmail.com',
              'password' => Hash::make('123456'),
              'phone' => '111111111',
              'role' => 'Admin'
            ],
            // [
            //   'firstname' => 'vendor',
            //   'lastname' => 'default',
            //   'email' => 'vendor@gmail.com',
            //   'password' => Hash::make('123456'),
            //   'phone' => '111111111',
            //   'role' => 'Vendor'
            // ],
            // [
            //   'firstname' => 'customer',
            //   'lastname' => 'default',
            //   'email' => 'customer@gmail.com',
            //   'password' => Hash::make('123456'),
            //   'phone' => '111111111',
            //   'role' => 'Customer'
            // ],
            // [
            //   'firstname' => 'guest',
            //   'lastname' => 'default',
            //   'email' => 'guest@gmail.com',
            //   'password' => Hash::make('123456'),
            //   'phone' => '111111111',
            //   'role' => 'Guest'
            // ],
          ];
  
          foreach ($rec as $key => $value) {
              
              $user = User::create(['firstname' => $value['firstname'],'lastname' => $value['lastname'],'email' => $value['email'],'password' => $value['password'],'phone' => $value['phone']]);
              $role = Role::create(['name' => $value['role']]);
              $permissions = Permission::pluck('id','id')->all();
              $role->syncPermissions($permissions);
              $user->assignRole([$role->id]);
  
          }

          $role = Role::create(['name' => 'Vendor']);
          $role = Role::create(['name' => 'Customer']);
    }
}
