<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->nullable();
            $table->integer('admin_id')->nullable();
            $table->integer('vendor_id')->nullable();
            $table->float('amount', 8, 2)->default(0);
            $table->enum('type',['withdrawal','deposit' , 'refunded' , 'hold-cash','cash'])->default('deposit');
            $table->enum('status',['pending','in-process','transferred'])->default('transferred');
            // $table->integer('payment_id')->default(1);
            $table->integer('source_id')->nullable(); // for module name
            $table->enum('source_type',['order','vendor','user','package'])->nullable();

            $table->string('payment_purpose')->nullable();
            $table->integer('shop_id')->nullable();
            $table->text('trx_id')->nullable();
            $table->text('transaction_text')->nullable();
            $table->text('payment_response')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}
