<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductGroupsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_groups', function (Blueprint $table) {
            
            $table->id();
            $table->string('sku')->nullable();
            $table->float('sale_price')->nullable();
            $table->float('unit_price')->nullable();
            $table->float('discount_price')->nullable();
            $table->enum('status',['active' , 'deactive'])->default('active');
            $table->integer('product_id')->nullable();
            $table->text('image')->nullable();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_groups');
    }
}
