<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderNumbersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_numbers', function (Blueprint $table) {
            $table->id();
            $table->string('number')->nullable();
            $table->string('order_status')->default('Pending'); // 0-> Pending, 1->Accept, 2->Complete
            $table->integer('id_user')->nullable();
            $table->integer('shop_id')->nullable();
            $table->integer('vendor_id')->nullable();


            $table->integer('promocode_id')->nullable();
            $table->text('promocode')->nullable();

            
            $table->string('firstname_b')->nullable();
            $table->string('lastname_b')->nullable();
            $table->string('email_b')->nullable();
            $table->string('phone_b')->nullable();
            $table->text('address_b')->nullable();
            $table->string('city_b')->nullable();
            $table->string('code_b')->nullable(); // Postal or Zip Code
            $table->string('country_b')->nullable();

            $table->string('firstname_s')->nullable();
            $table->string('lastname_s')->nullable();
            $table->string('email_s')->nullable();
            $table->string('phone_s')->nullable();
            $table->text('address_s')->nullable();
            $table->string('city_s')->nullable();
            $table->string('code_s')->nullable(); // Postal or Zip Code
            $table->string('payment_type')->nullable(); // Postal or Zip Code
            $table->string('country_s')->nullable();
            $table->float('shpping_charges')->nullable();
            $table->float('real_shpping_charges')->default(0);
            $table->boolean('is_seen')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_numbers');
    }
}
