<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) { // ORDER ITEM TABLE
            $table->id();
            $table->integer('id_ordernumber')->nullable();
            $table->integer('group_id')->nullable();
            $table->integer('product_id')->nullable();
            $table->float('sub_total')->nullable();
            $table->float('discount_sub_total')->default(0);
            $table->float('promo_discount_sub_total')->default(0);
            $table->float('promo_discount_value')->default(0);
            $table->string('promo_discount_type')->default('percentage');
            $table->text('order_json')->nullable();
            $table->integer('quantity')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
