<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductPromosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_promos', function (Blueprint $table) {
            $table->id();
            $table->integer( 'source_id' )->unsigned( );
            $table->enum( 'source_type' ,['product','category','shop'])->default('product' );
            $table->bigInteger( 'promocode_id' )->unsigned( );
            // $table->unique( [ 'product_id', 'voucher_id' ] );
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_promos');
    }
}
