<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePromocodesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('promocodes', function (Blueprint $table) {
            
            $table->id();
            $table->text('code')->nullable();// The voucher code
            $table->string('name')->nullable();// The human readable voucher code name
            $table->text('description')->nullable();// The description of the voucher - Not necessary 
            $table->integer('uses')->unsigned()->nullable();// The number of uses currently
            $table->integer('max_uses')->unsigned()->nullable();// The max uses this voucher has
            $table->integer('max_uses_user')->unsigned()->nullable();// How many times a user can use this voucher.
            $table->tinyInteger('type')->unsigned();// The type can be: voucher, discount, sale. What ever you want.
            $table->integer('discount_amount');// The amount to discount by (in pennies | percentage) in this example.
            $table->boolean('is_fixed')->default(false);// Whether or not the voucher is a percentage or a fixed price. 
            $table->string('starts_at');// When the voucher begins
            $table->string('expires_at');// When the voucher ends
            $table->integer('shop_id')->nullable();
            $table->integer('vendor_id')->nullable();
            $table->integer('is_applied_all')->default(0);
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('promocodes');
    }
}
