<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCategoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('categories', function (Blueprint $table) {
            
            $table->id();
            $table->string('name');
            $table->text('description');
            $table->unsignedBigInteger('id_parent');
            $table->string('image')->default('/uploads/default-thumbnail.png');
            $table->text('slug')->nullable();
            $table->boolean('status')->default(1); // 0->Active, 1->Deactive, 3->Disable by admin
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('categories');
    }
}
