<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            
            $table->id();
            $table->string('name');
            $table->decimal('unit_price', $precision = 8, $scale = 2)->nullable();
            $table->decimal('sale_price', $precision = 8, $scale = 2)->nullable();
            $table->text('short_description');
            $table->text('long_description');
            $table->text('product_sku')->nullable();
            $table->enum('product_type',['variation','simple'])->default('variation');
            $table->unsignedBigInteger('id_category');
            $table->string('boost_exp_date')->nullable();
            $table->boolean('is_featured')->default(0); // 0->Active, 1->Deactive, 3->Disable by admin
            $table->boolean('status')->default(1); // 0->Active, 1->Deactive, 3->Disable by admin
            $table->unsignedBigInteger('shop_id');
            $table->timestamps();
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}