<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShopAddressesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shop_addresses', function (Blueprint $table) {
            $table->id();
            $table->string('address_type'); //Main Shop or Main Branch
            $table->string('street_address');
            $table->string('suite_apt')->nullable();
            $table->string('city');
            $table->string('state');
            $table->string('zip');
            $table->decimal('latitude', $precision = 8, $scale = 2);
            $table->decimal('longitude', $precision = 8, $scale = 2);
            $table->boolean('status')->default(1);
            $table->unsignedBigInteger('shop_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shop_addresses');
    }
}
