<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShopsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shops', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('about_shop');
            $table->unsignedBigInteger('id_shop_niche'); // ID ( Fashion, Makeup, Garments, etc. )
            $table->boolean('shop_type'); // Virtural 1 or Physical 0
            $table->string('logo')->default('/uploads/default-logo.png');
            $table->integer('status')->default(1); // 0->suspend, 1->Active , 2->under-review
            $table->unsignedBigInteger('user_id');
            $table->string('delivery_time')->default(0);
            $table->text('cover_photo')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shops');
    }
}
