<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transactions extends Model
{
    use HasFactory;
    protected $guarded = [];

    // public function product()
    // {
    //     return $this->belongsTo(Products::class, "source_id", "id");
    // }

    protected $casts = [
        'transaction_text' => 'array',
        'payment_response' => 'array',
    ];


    public function purchasePackages()
    {
        return $this->belongsTo(PurchasePackage::class, "source_id", "id");
    }

    public function order()
    {
        return $this->belongsTo(OrderNumbers::class, "source_id", "id");
    }

    public function user()
    {
        return $this->belongsTo(User::class, "user_id");
    }

    public function vendor()
    {
        return $this->belongsTo(User::class, "vendor_id");
    }
    
}
