<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Stock extends Model
{
    use HasFactory;
    
    protected $fillable = ['sku', 'id_product', 'quantity', 'size', 'color_name', 'color_image' , 'product_group_id'];

    public function cart_items()
    {
        return $this->hasMany(Cart::class, "id_stock", "id");
    }

    public function product()
    {
        return $this->belongsTo(Products::class, "id_product", "id");
    }
}