<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Shops extends Model
{
    use HasFactory;
    
    protected $fillable = ['name', 'about_shop', 'id_shop_niche', 'shop_type', 'logo', 'status', 'user_id' , 'delivery_time' , 'cover_photo'];

    public function user()
    {
        return $this->belongsTo(User::class, "user_id", "id");
    }
    public function products()
    {
        return $this->hasMany(Products::class, "shop_id", "id");
    }


    public function address()
    {
        return $this->hasOne(ShopAddress::class, "shop_id");
    }

    public function shopRatings()
    {
        return $this->hasMany(ProductRatings::class, "id_shop", "id");
    }

    public function shipping()
    {
        return $this->hasOne(ShippingCharges::class, "shop_id");
    }

    // public function productRatings()
    // {
    //     return $this->hasMany(ProductRatings::class, "id_product", "id");
    // }

}
