<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchasePackage extends Model
{
    use HasFactory;
    protected $guarded = [];


    public function product(){
        return $this->belongsTo(Products::class ,'product_id');
    }

    public function package(){
        return $this->belongsTo(ProductPackages::class ,'product_package_id');
    }


    public function transaction()
    {
        return $this->hasMany(Transactions::class, "source_id", "id");
    }

}
