<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Products extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'unit_price', 'sale_price', 'short_description', 'long_description', 'id_category', 'status', 'shop_id','product_type','product_sku','boost_exp_date','is_featured'];

    public function shop()
    {
        return $this->belongsTo(Shops::class, "shop_id", "id");
    }

    public function category()
    {
        return $this->belongsTo(Categories::class, "id_category", "id");
    }

    public function gallery_images()
    {
        return $this->hasMany(ProductGallery::class, "id_product", "id");
    }

    public function stocks()
    {
        return $this->hasMany(Stock::class, "id_product", "id");
    }

    public function stock()
    {
        return $this->hasOne(Stock::class, "id_product", "id")->orderBy('id','desc');
    }

    public function variations()
    {
        return $this->hasMany(Stock::class, "id_product", "id")->select('id_product', 'id as stock_id', 'quantity', 'color_name', 'color_image', 'size');
    }
    
    public function specifications()
    {
        return $this->hasMany(MetaData::class, "id_product", "id");
    }

    public function productAttributes(){
        return $this->hasMany(ProductAttributes::class , 'product_id');
    }


    public function productGroup(){
        return $this->hasMany(ProductGroup::class , 'product_id');
    }

    public function attributes(){
        return $this->belongsToMany(Attributes::class ,"product_attributes" ,"product_id",'attribute_id');
    }

    public function shipCharges(){
        return $this->belongsTo(ShippingCharges::class ,"shop_id",'shop_id');
    }

    public function productRatings()
    {
        return $this->hasMany(ProductRatings::class, "id_product", "id");
    }

    public function wishLists()
    {
        return $this->hasMany(Wishlist::class, "product_id", "id");
    }


    public function productBoots()
    {
        return $this->hasMany(PurchasePackage::class, "product_id", "id");
    }

    public function transactions()
    {
        return $this->hasMany(Transactions::class, "source_id", "id")->where('source_type','order');
    }

    public function productOptionsName()
    {
        return $this->hasMany(ProductOptions::class, "product_id", "id");
    }

}